/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.schema.AddIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.IndexBelongsToConstraintException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchIndexException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.operations.KeyWriteOperations;
import org.neo4j.kernel.api.operations.SchemaReadOperations;
import org.neo4j.kernel.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;

public class DataIntegrityValidatingStatementOperations
implements KeyWriteOperations,
SchemaWriteOperations {
    private final KeyWriteOperations keyWriteDelegate;
    private final SchemaReadOperations schemaReadDelegate;
    private final SchemaWriteOperations schemaWriteDelegate;

    public DataIntegrityValidatingStatementOperations(KeyWriteOperations keyWriteDelegate, SchemaReadOperations schemaReadDelegate, SchemaWriteOperations schemaWriteDelegate) {
        this.keyWriteDelegate = keyWriteDelegate;
        this.schemaReadDelegate = schemaReadDelegate;
        this.schemaWriteDelegate = schemaWriteDelegate;
    }

    @Override
    public long propertyKeyGetOrCreateForName(StatementState state, String propertyKey) throws SchemaKernelException {
        return this.keyWriteDelegate.propertyKeyGetOrCreateForName(state, this.checkValidTokenName(propertyKey));
    }

    private String checkValidTokenName(String name) throws IllegalTokenNameException {
        if (name == null || name.isEmpty()) {
            throw new IllegalTokenNameException(name);
        }
        return name;
    }

    @Override
    public long labelGetOrCreateForName(StatementState state, String label) throws SchemaKernelException {
        return this.keyWriteDelegate.labelGetOrCreateForName(state, this.checkValidTokenName(label));
    }

    @Override
    public IndexDescriptor indexCreate(StatementState state, long labelId, long propertyKey) throws SchemaKernelException {
        try {
            this.checkIndexExistence(state, labelId, propertyKey);
        }
        catch (KernelException e) {
            throw new AddIndexFailureException(labelId, propertyKey, e);
        }
        return this.schemaWriteDelegate.indexCreate(state, labelId, propertyKey);
    }

    @Override
    public IndexDescriptor uniqueIndexCreate(StatementState state, long labelId, long propertyKey) throws SchemaKernelException {
        try {
            this.checkIndexExistence(state, labelId, propertyKey);
        }
        catch (KernelException e) {
            throw new AddIndexFailureException(labelId, propertyKey, e);
        }
        return this.schemaWriteDelegate.uniqueIndexCreate(state, labelId, propertyKey);
    }

    private void checkIndexExistence(StatementState state, long labelId, long propertyKey) throws SchemaKernelException {
        for (IndexDescriptor descriptor : IteratorUtil.loop(this.schemaReadDelegate.indexesGetForLabel(state, labelId))) {
            if (descriptor.getPropertyKeyId() != propertyKey) continue;
            throw new AlreadyIndexedException(descriptor);
        }
        for (IndexDescriptor descriptor : IteratorUtil.loop(this.schemaReadDelegate.uniqueIndexesGetForLabel(state, labelId))) {
            if (descriptor.getPropertyKeyId() != propertyKey) continue;
            throw new AlreadyConstrainedException(new UniquenessConstraint(descriptor.getLabelId(), descriptor.getPropertyKeyId()));
        }
    }

    @Override
    public void indexDrop(StatementState state, IndexDescriptor descriptor) throws DropIndexFailureException {
        try {
            this.assertIsNotUniqueIndex(descriptor, this.schemaReadDelegate.uniqueIndexesGetForLabel(state, descriptor.getLabelId()));
            this.assertIndexExists(descriptor, this.schemaReadDelegate.indexesGetForLabel(state, descriptor.getLabelId()));
        }
        catch (SchemaKernelException e) {
            throw new DropIndexFailureException(descriptor, e);
        }
        this.schemaWriteDelegate.indexDrop(state, descriptor);
    }

    private void assertIsNotUniqueIndex(IndexDescriptor descriptor, Iterator<IndexDescriptor> uniqueIndexes) throws IndexBelongsToConstraintException {
        while (uniqueIndexes.hasNext()) {
            IndexDescriptor uniqueIndex = uniqueIndexes.next();
            if (uniqueIndex.getPropertyKeyId() != descriptor.getPropertyKeyId()) continue;
            throw new IndexBelongsToConstraintException(descriptor);
        }
    }

    @Override
    public void uniqueIndexDrop(StatementState state, IndexDescriptor descriptor) throws DropIndexFailureException {
        try {
            this.assertIndexExists(descriptor, this.schemaReadDelegate.uniqueIndexesGetForLabel(state, descriptor.getLabelId()));
        }
        catch (NoSuchIndexException e) {
            throw new DropIndexFailureException(descriptor, e);
        }
        this.schemaWriteDelegate.uniqueIndexDrop(state, descriptor);
    }

    @Override
    public UniquenessConstraint uniquenessConstraintCreate(StatementState state, long labelId, long propertyKey) throws SchemaKernelException {
        Iterator<UniquenessConstraint> constraints = this.schemaReadDelegate.constraintsGetForLabelAndPropertyKey(state, labelId, propertyKey);
        if (constraints.hasNext()) {
            throw new AlreadyConstrainedException(constraints.next());
        }
        return this.schemaWriteDelegate.uniquenessConstraintCreate(state, labelId, propertyKey);
    }

    private void assertIndexExists(IndexDescriptor descriptor, Iterator<IndexDescriptor> indexes) throws NoSuchIndexException {
        for (IndexDescriptor existing : IteratorUtil.loop(indexes)) {
            if (existing.getPropertyKeyId() != descriptor.getPropertyKeyId()) continue;
            return;
        }
        throw new NoSuchIndexException(descriptor);
    }

    @Override
    public void constraintDrop(StatementState state, UniquenessConstraint constraint) {
        this.schemaWriteDelegate.constraintDrop(state, constraint);
    }
}

