/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.operations.EntityReadOperations;
import org.neo4j.kernel.api.operations.SchemaReadOperations;
import org.neo4j.kernel.api.operations.StatementState;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.impl.api.CacheLoader;
import org.neo4j.kernel.impl.api.PersistenceCache;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.api.SchemaCache;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;

public class CachingStatementOperations
implements EntityReadOperations,
SchemaReadOperations {
    private static final Function<? super SchemaRule, IndexDescriptor> TO_INDEX_RULE = new Function<SchemaRule, IndexDescriptor>(){

        @Override
        public IndexDescriptor apply(SchemaRule from) {
            IndexRule rule = (IndexRule)from;
            return new IndexDescriptor(rule.getLabel(), rule.getPropertyKey());
        }
    };
    private final CacheLoader<Iterator<Property>> nodePropertyLoader = new CacheLoader<Iterator<Property>>(){

        @Override
        public Iterator<Property> load(StatementState state, long id) throws EntityNotFoundException {
            return CachingStatementOperations.this.entityReadDelegate.nodeGetAllProperties(state, id);
        }
    };
    private final CacheLoader<Iterator<Property>> relationshipPropertyLoader = new CacheLoader<Iterator<Property>>(){

        @Override
        public Iterator<Property> load(StatementState state, long id) throws EntityNotFoundException {
            return CachingStatementOperations.this.entityReadDelegate.relationshipGetAllProperties(state, id);
        }
    };
    private final CacheLoader<Iterator<Property>> graphPropertyLoader = new CacheLoader<Iterator<Property>>(){

        @Override
        public Iterator<Property> load(StatementState state, long id) throws EntityNotFoundException {
            return CachingStatementOperations.this.entityReadDelegate.graphGetAllProperties(state);
        }
    };
    private final CacheLoader<Set<Long>> nodeLabelLoader = new CacheLoader<Set<Long>>(){

        @Override
        public Set<Long> load(StatementState state, long id) throws EntityNotFoundException {
            return IteratorUtil.asSet(CachingStatementOperations.this.entityReadDelegate.nodeGetLabels(state, id));
        }
    };
    private final PersistenceCache persistenceCache;
    private final SchemaCache schemaCache;
    private final EntityReadOperations entityReadDelegate;
    private final SchemaReadOperations schemaReadDelegate;

    public CachingStatementOperations(EntityReadOperations entityReadDelegate, SchemaReadOperations schemaReadDelegate, PersistenceCache persistenceCache, SchemaCache schemaCache) {
        this.entityReadDelegate = entityReadDelegate;
        this.schemaReadDelegate = schemaReadDelegate;
        this.persistenceCache = persistenceCache;
        this.schemaCache = schemaCache;
    }

    @Override
    public boolean nodeHasLabel(StatementState state, long nodeId, long labelId) throws EntityNotFoundException {
        return this.persistenceCache.nodeHasLabel(state, nodeId, labelId, this.nodeLabelLoader);
    }

    @Override
    public PrimitiveLongIterator nodeGetLabels(StatementState state, long nodeId) throws EntityNotFoundException {
        Iterator<Long> iterator = this.persistenceCache.nodeGetLabels(state, nodeId, this.nodeLabelLoader).iterator();
        return IteratorUtil.toPrimitiveLongIterator(iterator);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(StatementState state, long labelId) {
        return CachingStatementOperations.toIndexDescriptors(this.schemaCache.getSchemaRulesForLabel(labelId), SchemaRule.Kind.INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(StatementState state) {
        return CachingStatementOperations.toIndexDescriptors(this.schemaCache.getSchemaRules(), SchemaRule.Kind.INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(StatementState state, long labelId) {
        return CachingStatementOperations.toIndexDescriptors(this.schemaCache.getSchemaRulesForLabel(labelId), SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll(StatementState state) {
        return CachingStatementOperations.toIndexDescriptors(this.schemaCache.getSchemaRules(), SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
    }

    private static Iterator<IndexDescriptor> toIndexDescriptors(Iterable<SchemaRule> rules, final SchemaRule.Kind kind) {
        Iterator<SchemaRule> filteredRules = Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule item) {
                return item.getKind() == kind;
            }
        }, rules.iterator());
        return Iterables.map(TO_INDEX_RULE, filteredRules);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(StatementState state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        IndexRule rule = this.indexRule(index);
        if (rule != null) {
            return rule.getOwningConstraint();
        }
        return this.schemaReadDelegate.indexGetOwningUniquenessConstraintId(state, index);
    }

    @Override
    public long indexGetCommittedId(StatementState state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        IndexRule rule = this.indexRule(index);
        if (rule != null) {
            return rule.getId();
        }
        return this.schemaReadDelegate.indexGetCommittedId(state, index);
    }

    private IndexRule indexRule(IndexDescriptor index) {
        for (SchemaRule rule : this.schemaCache.getSchemaRulesForLabel(index.getLabelId())) {
            IndexRule indexRule;
            if (!(rule instanceof IndexRule) || (indexRule = (IndexRule)rule).getPropertyKey() != index.getPropertyKeyId()) continue;
            return indexRule;
        }
        return null;
    }

    @Override
    public PrimitiveLongIterator nodeGetPropertyKeys(StatementState state, long nodeId) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetPropertyKeys(state, nodeId, this.nodePropertyLoader);
    }

    @Override
    public Property nodeGetProperty(StatementState state, long nodeId, long propertyKeyId) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetProperty(state, nodeId, propertyKeyId, this.nodePropertyLoader);
    }

    @Override
    public boolean nodeHasProperty(StatementState state, long nodeId, long propertyKeyId) throws EntityNotFoundException {
        return !this.nodeGetProperty(state, nodeId, propertyKeyId).isNoProperty();
    }

    @Override
    public Iterator<Property> nodeGetAllProperties(StatementState state, long nodeId) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetProperties(state, nodeId, this.nodePropertyLoader);
    }

    @Override
    public PrimitiveLongIterator relationshipGetPropertyKeys(StatementState state, long relationshipId) throws EntityNotFoundException {
        return new PropertyKeyIdIterator(this.relationshipGetAllProperties(state, relationshipId));
    }

    @Override
    public Property relationshipGetProperty(StatementState state, long relationshipId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        return this.persistenceCache.relationshipGetProperty(state, relationshipId, propertyKeyId, this.relationshipPropertyLoader);
    }

    @Override
    public boolean relationshipHasProperty(StatementState state, long relationshipId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        return !this.relationshipGetProperty(state, relationshipId, propertyKeyId).isNoProperty();
    }

    @Override
    public Iterator<Property> relationshipGetAllProperties(StatementState state, long nodeId) throws EntityNotFoundException {
        return this.persistenceCache.relationshipGetProperties(state, nodeId, this.relationshipPropertyLoader);
    }

    @Override
    public PrimitiveLongIterator graphGetPropertyKeys(StatementState state) {
        return this.persistenceCache.graphGetPropertyKeys(state, this.graphPropertyLoader);
    }

    @Override
    public Property graphGetProperty(StatementState state, long propertyKeyId) throws PropertyKeyIdNotFoundException {
        return this.persistenceCache.graphGetProperty(state, this.graphPropertyLoader, propertyKeyId);
    }

    @Override
    public boolean graphHasProperty(StatementState state, long propertyKeyId) throws PropertyKeyIdNotFoundException {
        return !this.graphGetProperty(state, propertyKeyId).isNoProperty();
    }

    @Override
    public Iterator<Property> graphGetAllProperties(StatementState state) {
        return this.persistenceCache.graphGetProperties(state, this.graphPropertyLoader);
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(StatementState state, long labelId) {
        return this.entityReadDelegate.nodesGetForLabel(state, labelId);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexLookup(StatementState state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        return this.entityReadDelegate.nodesGetFromIndexLookup(state, index, value);
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(StatementState state, long labelId, long propertyKey) throws SchemaRuleNotFoundException {
        return this.schemaReadDelegate.indexesGetForLabelAndPropertyKey(state, labelId, propertyKey);
    }

    @Override
    public InternalIndexState indexGetState(StatementState state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.schemaReadDelegate.indexGetState(state, descriptor);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(StatementState state, long labelId, long propertyKeyId) {
        return this.schemaReadDelegate.constraintsGetForLabelAndPropertyKey(state, labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(StatementState state, long labelId) {
        return this.schemaReadDelegate.constraintsGetForLabel(state, labelId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll(StatementState state) {
        return this.schemaReadDelegate.constraintsGetAll(state);
    }

    @Override
    public String indexGetFailure(StatementState state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.schemaReadDelegate.indexGetFailure(state, descriptor);
    }
}

