/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.lang.reflect.Array;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyDatas;

abstract class PropertyWithValue
extends Property {
    PropertyWithValue() {
    }

    @Override
    public abstract Object value();

    @Override
    public Object value(Object defaultValue) {
        return this.value();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[propertyKeyId=" + this.propertyKeyId() + ", value=" + this.valueToString() + "]";
    }

    String valueToString() {
        return this.value().toString();
    }

    @Override
    public String stringValue() {
        Object value = this.value();
        throw new ClassCastException(String.format("[%s:%s] is not a String", value, value.getClass().getSimpleName()));
    }

    @Override
    public String stringValue(String defaultValue) {
        return this.stringValue();
    }

    @Override
    public Number numberValue() {
        Object value = this.value();
        throw new ClassCastException(String.format("[%s:%s] is not a Number", value, value.getClass().getSimpleName()));
    }

    @Override
    public Number numberValue(Number defaultValue) {
        return this.numberValue();
    }

    @Override
    public int intValue() {
        Object value = this.value();
        throw new ClassCastException(String.format("[%s:%s] is not an int", value, value.getClass().getSimpleName()));
    }

    @Override
    public int intValue(int defaultValue) {
        return this.intValue();
    }

    @Override
    public long longValue() {
        Object value = this.value();
        throw new ClassCastException(String.format("[%s:%s] is not a long", value, value.getClass().getSimpleName()));
    }

    @Override
    public long longValue(long defaultValue) {
        return this.longValue();
    }

    @Override
    public boolean booleanValue() {
        Object value = this.value();
        throw new ClassCastException(String.format("[%s:%s] is not a boolean", value, value.getClass().getSimpleName()));
    }

    @Override
    public boolean booleanValue(boolean defaultValue) {
        return this.booleanValue();
    }

    @Override
    @Deprecated
    public PropertyData asPropertyDataJustForIntegration() {
        return PropertyDatas.forStringOrArray((int)this.propertyKeyId(), -1L, this.value());
    }

    protected boolean valueCompare(Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            return this.compareNumbers((Number)a, (Number)b);
        }
        if ((a instanceof String || a instanceof Character) && (b instanceof String || b instanceof Character)) {
            return a.toString().equals(b.toString());
        }
        if (a.getClass().isArray() && b.getClass().isArray()) {
            return this.compareArrays(a, b);
        }
        return false;
    }

    private boolean compareArrays(Object a, Object b) {
        int bLength;
        int aLength = Array.getLength(a);
        if (aLength != (bLength = Array.getLength(b))) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            Object bObj;
            Object aObj = Array.get(a, i);
            if (this.valueCompare(aObj, bObj = Array.get(b, i))) continue;
            return false;
        }
        return true;
    }

    private boolean compareNumbers(Number aNumber, Number bNumber) {
        if (aNumber instanceof Float || bNumber instanceof Float || aNumber instanceof Double || bNumber instanceof Double) {
            double b = bNumber.doubleValue();
            double a = aNumber.doubleValue();
            return a == b;
        }
        return aNumber.longValue() == bNumber.longValue();
    }
}

