/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyDatas;

final class NoGraphProperty
extends Property {
    private final long propertyKeyId;

    NoGraphProperty(long propertyKeyId) {
        this.propertyKeyId = propertyKeyId;
    }

    public String toString() {
        return String.format("%s[propertyKeyId=%s]", this.getClass().getSimpleName(), this.propertyKeyId);
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof NoGraphProperty && this.propertyKeyId == ((NoGraphProperty)o).propertyKeyId;
    }

    @Override
    public boolean isNoProperty() {
        return true;
    }

    @Override
    public int hashCode() {
        return (int)(this.propertyKeyId ^ this.propertyKeyId >>> 32);
    }

    @Override
    public long propertyKeyId() {
        return this.propertyKeyId;
    }

    @Override
    public boolean valueEquals(Object value) {
        return false;
    }

    @Override
    public Object value(Object defaultValue) {
        return defaultValue;
    }

    @Override
    public String stringValue(String defaultValue) {
        return defaultValue;
    }

    @Override
    public Number numberValue(Number defaultValue) {
        return defaultValue;
    }

    @Override
    public int intValue(int defaultValue) {
        return defaultValue;
    }

    @Override
    public long longValue(long defaultValue) {
        return defaultValue;
    }

    @Override
    public boolean booleanValue(boolean defaultValue) {
        return defaultValue;
    }

    @Override
    public Object value() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId);
    }

    @Override
    public String stringValue() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId);
    }

    @Override
    public boolean booleanValue() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId);
    }

    @Override
    public Number numberValue() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId);
    }

    @Override
    public int intValue() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId);
    }

    @Override
    public long longValue() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId);
    }

    @Override
    @Deprecated
    public PropertyData asPropertyDataJustForIntegration() {
        return PropertyDatas.noProperty(this.propertyKeyId);
    }
}

