/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.concurrent.Callable;
import org.neo4j.kernel.api.properties.FullSizeProperty;

abstract class LazyProperty<T>
extends FullSizeProperty {
    private volatile Object value;

    LazyProperty(long propertyKeyId, Callable<T> producer) {
        super(propertyKeyId);
        this.value = producer;
    }

    @Override
    final boolean hasEqualValue(FullSizeProperty that) {
        return this.valueEquals(((LazyProperty)that).value());
    }

    @Override
    public abstract boolean valueEquals(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T value() {
        Object value = this.value;
        if (value instanceof Callable) {
            LazyProperty lazyProperty = this;
            synchronized (lazyProperty) {
                value = this.value;
                if (value instanceof Callable) {
                    try {
                        this.value = value = ((Callable)value).call();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.cast(value);
    }

    private T cast(Object value) {
        return (T)value;
    }
}

