/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.FullSizeProperty;

class DoubleArrayProperty
extends FullSizeProperty {
    private final double[] value;

    DoubleArrayProperty(long propertyKeyId, double[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public double[] value() {
        return this.value;
    }

    @Override
    public boolean valueEquals(Object value) {
        if (value instanceof double[]) {
            return Arrays.equals(this.value, (double[])value);
        }
        return this.valueCompare(this.value, value);
    }

    @Override
    int valueHash() {
        return Arrays.hashCode(this.value);
    }

    @Override
    boolean hasEqualValue(FullSizeProperty that) {
        return Arrays.equals(this.value, ((DoubleArrayProperty)that).value);
    }
}

