/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.FullSizeProperty;

class ByteArrayProperty
extends FullSizeProperty {
    private final byte[] value;

    ByteArrayProperty(long propertyKeyId, byte[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public byte[] value() {
        return this.value;
    }

    @Override
    public boolean valueEquals(Object value) {
        if (value instanceof byte[]) {
            return Arrays.equals(this.value, (byte[])value);
        }
        return this.valueCompare(this.value, value);
    }

    @Override
    int valueHash() {
        return Arrays.hashCode(this.value);
    }

    @Override
    boolean hasEqualValue(FullSizeProperty that) {
        return Arrays.equals(this.value, ((ByteArrayProperty)that).value);
    }
}

