/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.lang.reflect.Array;
import sun.misc.BASE64Encoder;

public class ArrayEncoder {
    private static final BASE64Encoder base64Encoder = new BASE64Encoder();

    public static String encode(Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Only works with arrays");
        }
        StringBuilder builder = new StringBuilder();
        int length = Array.getLength(array);
        String type = "";
        for (int i = 0; i < length; ++i) {
            Object o = Array.get(array, i);
            if (o instanceof Number) {
                type = "D";
                builder.append(((Number)o).doubleValue());
            } else if (o instanceof Boolean) {
                type = "Z";
                builder.append(o);
            } else {
                type = "L";
                String str = o.toString();
                builder.append(base64Encoder.encode(str.getBytes()));
            }
            builder.append("|");
        }
        return type + builder.toString();
    }
}

