/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexIterable;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.EmbeddedReadOnlyGraphDatabase;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;

public class GraphDatabaseFactory {
    private final GraphDatabaseFactoryState state;

    public GraphDatabaseFactory() {
        this(new GraphDatabaseFactoryState());
    }

    protected GraphDatabaseFactory(GraphDatabaseFactoryState state) {
        this.state = state;
    }

    protected GraphDatabaseFactoryState getCurrentState() {
        return this.state;
    }

    protected GraphDatabaseFactoryState getStateCopy() {
        return new GraphDatabaseFactoryState(this.getCurrentState());
    }

    public GraphDatabaseService newEmbeddedDatabase(String path) {
        return this.newEmbeddedDatabaseBuilder(path).newGraphDatabase();
    }

    public GraphDatabaseBuilder newEmbeddedDatabaseBuilder(final String path) {
        final GraphDatabaseFactoryState state = this.getStateCopy();
        return new GraphDatabaseBuilder(new GraphDatabaseBuilder.DatabaseCreator(){

            @Override
            public GraphDatabaseService newDatabase(Map<String, String> config) {
                config.put("ephemeral", "false");
                if ("true".equalsIgnoreCase(config.get(GraphDatabaseSettings.read_only.name()))) {
                    return new EmbeddedReadOnlyGraphDatabase(path, config, state.getIndexProviders(), state.getKernelExtension(), state.getCacheProviders(), state.getTransactionInterceptorProviders());
                }
                return new EmbeddedGraphDatabase(path, config, state.getIndexProviders(), state.getKernelExtension(), state.getCacheProviders(), state.getTransactionInterceptorProviders());
            }
        });
    }

    public Iterable<IndexProvider> getIndexProviders() {
        return this.getCurrentState().getIndexProviders();
    }

    public GraphDatabaseFactory setIndexProviders(IndexIterable indexIterable) {
        this.getCurrentState().setIndexProviders(indexIterable);
        return this;
    }

    public Iterable<KernelExtensionFactory<?>> getKernelExtension() {
        return this.getCurrentState().getKernelExtension();
    }

    public GraphDatabaseFactory addKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        this.getCurrentState().addKernelExtensions(newKernelExtensions);
        return this;
    }

    public GraphDatabaseFactory setKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        this.getCurrentState().setKernelExtensions(newKernelExtensions);
        return this;
    }

    public List<CacheProvider> getCacheProviders() {
        return this.getCurrentState().getCacheProviders();
    }

    public GraphDatabaseFactory setCacheProviders(Iterable<CacheProvider> newCacheProviders) {
        this.getCurrentState().setCacheProviders(newCacheProviders);
        return this;
    }

    public List<TransactionInterceptorProvider> getTransactionInterceptorProviders() {
        return this.getCurrentState().getTransactionInterceptorProviders();
    }

    public GraphDatabaseFactory setTransactionInterceptorProviders(Iterable<TransactionInterceptorProvider> transactionInterceptorProviders) {
        this.getCurrentState().setTransactionInterceptorProviders(transactionInterceptorProviders);
        return this;
    }
}

