/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;
import java.util.regex.Pattern;
import org.neo4j.graphdb.NotFoundException;

public class FileUtils {
    private static int WINDOWS_RETRY_COUNT = 3;

    public static void deleteRecursively(File directory) throws IOException {
        Stack<File> stack = new Stack<File>();
        LinkedList<File> temp = new LinkedList<File>();
        stack.push(directory.getAbsoluteFile());
        while (!stack.isEmpty()) {
            File top = (File)stack.pop();
            if (top.listFiles() != null) {
                for (File child : top.listFiles()) {
                    if (child.isFile()) {
                        if (FileUtils.deleteFile(child)) continue;
                        throw new IOException("Failed to delete " + child.getCanonicalPath());
                    }
                    temp.add(child);
                }
            }
            if (top.listFiles() == null || top.listFiles().length == 0) {
                if (!FileUtils.deleteFile(top)) {
                    throw new IOException("Failed to delete " + top.getCanonicalPath());
                }
            } else {
                stack.push(top);
                for (File f : temp) {
                    stack.push(f);
                }
            }
            temp.clear();
        }
    }

    public static boolean deleteFile(File file) {
        if (!file.exists()) {
            return true;
        }
        int count = 0;
        boolean deleted = false;
        do {
            if (deleted = file.delete()) continue;
            ++count;
            FileUtils.waitSome();
        } while (!deleted && count <= WINDOWS_RETRY_COUNT);
        return deleted;
    }

    public static File[] deleteFiles(File directory, String regexPattern) throws IOException {
        Pattern pattern = Pattern.compile(regexPattern);
        ArrayList<File> deletedFiles = new ArrayList<File>();
        for (File file : directory.listFiles()) {
            if (!pattern.matcher(file.getName()).find()) continue;
            if (!file.delete()) {
                throw new IOException("Couldn't delete file '" + file.getAbsolutePath() + "'");
            }
            deletedFiles.add(file);
        }
        return deletedFiles.toArray(new File[deletedFiles.size()]);
    }

    public static void moveFile(File toMove, File target) throws IOException {
        if (!toMove.exists()) {
            throw new NotFoundException("Source file[" + toMove.getName() + "] not found");
        }
        if (target.exists()) {
            throw new NotFoundException("Target file[" + target.getName() + "] already exists");
        }
        if (toMove.renameTo(target)) {
            return;
        }
        if (toMove.isDirectory()) {
            target.mkdirs();
            FileUtils.copyRecursively(toMove, target);
            FileUtils.deleteRecursively(toMove);
        } else {
            FileUtils.copyFile(toMove, target);
            FileUtils.deleteFile(toMove);
        }
    }

    public static File moveFileToDirectory(File toMove, File targetDirectory) throws IOException {
        if (!targetDirectory.isDirectory()) {
            throw new IllegalArgumentException("Move target must be a directory, not " + targetDirectory);
        }
        File target = new File(targetDirectory, toMove.getName());
        FileUtils.moveFile(toMove, target);
        return target;
    }

    public static boolean renameFile(File srcFile, File renameToFile) {
        if (!srcFile.exists()) {
            throw new NotFoundException("Source file[" + srcFile.getName() + "] not found");
        }
        if (renameToFile.exists()) {
            throw new NotFoundException("Target file[" + renameToFile.getName() + "] already exists");
        }
        int count = 0;
        boolean renamed = false;
        do {
            if (renamed = srcFile.renameTo(renameToFile)) continue;
            ++count;
            FileUtils.waitSome();
        } while (!renamed && count <= WINDOWS_RETRY_COUNT);
        return renamed;
    }

    public static void truncateFile(FileChannel fileChannel, long position) throws IOException {
        int count = 0;
        boolean success = false;
        IOException cause = null;
        do {
            ++count;
            try {
                fileChannel.truncate(position);
                success = true;
            }
            catch (IOException e) {
                cause = e;
            }
        } while (!success && count <= WINDOWS_RETRY_COUNT);
        if (!success) {
            throw cause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncateFile(File file, long position) throws IOException {
        RandomAccessFile access = new RandomAccessFile(file, "rw");
        try {
            FileUtils.truncateFile(access.getChannel(), position);
        }
        finally {
            access.close();
        }
    }

    private static void waitSome() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ee) {
            Thread.interrupted();
        }
        System.gc();
    }

    public static String fixSeparatorsInPath(String path) {
        String fileSeparator = System.getProperty("file.separator");
        if ("\\".equals(fileSeparator)) {
            path = path.replace('/', '\\');
        } else if ("/".equals(fileSeparator)) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    public static void copyFile(File srcFile, File dstFile) throws IOException {
        dstFile.getParentFile().mkdirs();
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            int bytesRead;
            input = new FileInputStream(srcFile);
            output = new FileOutputStream(dstFile);
            int bufferSize = 1024;
            byte[] buffer = new byte[bufferSize];
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new IOException("Could not copy '" + srcFile + "' to '" + dstFile + "'", e);
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    public static void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        for (File fromFile : fromDirectory.listFiles()) {
            File toFile = new File(toDirectory, fromFile.getName());
            if (fromFile.isDirectory()) {
                toFile.mkdir();
                FileUtils.copyRecursively(fromFile, toFile);
                continue;
            }
            FileUtils.copyFile(fromFile, toFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File target, String text, boolean append) throws IOException {
        if (!target.exists()) {
            target.getParentFile().mkdirs();
            target.createNewFile();
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(target, append), "UTF-8");
        try {
            out.write(text);
        }
        finally {
            ((Writer)out).close();
        }
    }

    public static BufferedReader newBufferedFileReader(File file, Charset charset) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
    }

    public static PrintWriter newFilePrintWriter(File file, Charset charset) throws FileNotFoundException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), charset));
    }
}

