/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;

public enum StoreFile {
    NEO_STORE("NeoStore", ""),
    NODE_STORE("NodeStore", ".nodestore.db"),
    NODE_LABEL_STORE("NodeLabelStore", ".nodestore.db.labels", false),
    PROPERTY_STORE("PropertyStore", ".propertystore.db"),
    PROPERTY_ARRAY_STORE("ArrayPropertyStore", ".propertystore.db.arrays"),
    PROPERTY_STRING_STORE("StringPropertyStore", ".propertystore.db.strings"),
    PROPERTY_INDEX_STORE("PropertyIndexStore", ".propertystore.db.index"),
    PROPERTY_INDEX_KEYS_STORE("StringPropertyStore", ".propertystore.db.index.keys"),
    RELATIONSHIP_STORE("RelationshipStore", ".relationshipstore.db"),
    RELATIONSHIP_TYPE_STORE("RelationshipTypeStore", ".relationshiptypestore.db"),
    RELATIONSHIP_TYPE_NAMES_STORE("StringPropertyStore", ".relationshiptypestore.db.names"),
    LABEL_NAME_STORE("LabelNameStore", ".labeltokenstore.db", false),
    LABEL_NAME_NAMES_STORE("StringPropertyStore", ".labeltokenstore.db.names", false),
    SCHEMA_STORE("SchemaStore", ".schemastore.db", false);

    private final String typeDescriptor;
    private final String storeFileNamePart;
    private final boolean existsInBoth;

    private StoreFile(String typeDescriptor, String storeFileNamePart) {
        this(typeDescriptor, storeFileNamePart, true);
    }

    private StoreFile(String typeDescriptor, String storeFileNamePart, boolean existsInBoth) {
        this.typeDescriptor = typeDescriptor;
        this.storeFileNamePart = storeFileNamePart;
        this.existsInBoth = existsInBoth;
    }

    public String legacyVersion() {
        return this.typeDescriptor + " " + "v0.A.0";
    }

    public String storeFileName() {
        return "neostore" + this.storeFileNamePart;
    }

    public String idFileName() {
        return this.storeFileName() + ".id";
    }

    public static Iterable<StoreFile> legacyStoreFiles() {
        Predicate<StoreFile> predicate = new Predicate<StoreFile>(){

            @Override
            public boolean accept(StoreFile item) {
                return item.existsInBoth;
            }
        };
        Iterable<StoreFile> storeFiles = StoreFile.currentStoreFiles();
        return Iterables.filter(predicate, storeFiles);
    }

    public static Iterable<StoreFile> currentStoreFiles() {
        return Iterables.iterable(StoreFile.values());
    }

    public static void move(FileSystemAbstraction fs, File fromDirectory, File toDirectory, Iterable<StoreFile> files) throws IOException {
        for (StoreFile storeFile : files) {
            StoreFile.moveFile(fs, storeFile.storeFileName(), fromDirectory, toDirectory);
            StoreFile.moveFile(fs, storeFile.idFileName(), fromDirectory, toDirectory);
        }
    }

    static void moveFile(FileSystemAbstraction fs, String fileName, File fromDirectory, File toDirectory) throws IOException {
        fs.moveToDirectory(new File(fromDirectory, fileName), toDirectory);
    }
}

