/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.util.Bits;

public class NodeLabelRecordLogic {
    private static final int LABEL_BITS = 36;
    private final NodeRecord node;
    private final NodeStore nodeStore;

    public NodeLabelRecordLogic(NodeRecord node, NodeStore nodeStore) {
        this.node = node;
        this.nodeStore = nodeStore;
    }

    public Iterable<DynamicRecord> add(long labelId) {
        long existingLabelsField = this.node.getLabelField();
        byte header = NodeLabelRecordLogic.getHeader(existingLabelsField);
        long existingLabelsBits = NodeLabelRecordLogic.parseLabelsBody(existingLabelsField);
        Collection<DynamicRecord> changedDynamicRecords = Collections.emptyList();
        if (!NodeLabelRecordLogic.highHeaderBitSet(header)) {
            long[] newLabelIds;
            long[] lArray;
            if (header == 0) {
                long[] lArray2 = new long[1];
                lArray = lArray2;
                lArray2[0] = labelId;
            } else {
                lArray = newLabelIds = this.concatAndSort(NodeLabelRecordLogic.parseInlined(existingLabelsBits, header), labelId);
            }
            if (!this.tryInlineInNodeRecord(newLabelIds, changedDynamicRecords)) {
                changedDynamicRecords = this.nodeStore.allocateRecordsForDynamicLabels(newLabelIds);
                this.node.setLabelField(NodeLabelRecordLogic.dynamicPointer(changedDynamicRecords), changedDynamicRecords);
            }
        } else {
            this.nodeStore.ensureHeavy(this.node, existingLabelsBits);
            Collection<DynamicRecord> existingRecords = this.node.getDynamicLabelRecords();
            long[] existingLabelIds = this.nodeStore.getDynamicLabelsArray(existingRecords);
            long[] newLabelIds = this.concatAndSort(existingLabelIds, labelId);
            changedDynamicRecords = this.nodeStore.allocateRecordsForDynamicLabels(newLabelIds, existingRecords.iterator());
            this.node.setLabelField(NodeLabelRecordLogic.dynamicPointer(changedDynamicRecords), changedDynamicRecords);
        }
        return changedDynamicRecords;
    }

    public Iterable<DynamicRecord> set(long[] labelIds) {
        long existingLabelsField = this.node.getLabelField();
        byte header = NodeLabelRecordLogic.getHeader(existingLabelsField);
        long existingLabelsBits = NodeLabelRecordLogic.parseLabelsBody(existingLabelsField);
        Collection<DynamicRecord> changedDynamicRecords = Collections.emptyList();
        if (NodeLabelRecordLogic.highHeaderBitSet(header)) {
            this.nodeStore.ensureHeavy(this.node, existingLabelsBits);
            changedDynamicRecords = this.node.getDynamicLabelRecords();
            for (DynamicRecord record : changedDynamicRecords) {
                record.setInUse(false);
            }
        }
        if (!this.tryInlineInNodeRecord(labelIds, changedDynamicRecords)) {
            HashSet<DynamicRecord> allRecords = new HashSet<DynamicRecord>(changedDynamicRecords);
            Collection<DynamicRecord> allocatedRecords = this.nodeStore.allocateRecordsForDynamicLabels(labelIds, changedDynamicRecords.iterator());
            allRecords.addAll(allocatedRecords);
            this.node.setLabelField(NodeLabelRecordLogic.dynamicPointer(allocatedRecords), allocatedRecords);
            changedDynamicRecords = allRecords;
        }
        return changedDynamicRecords;
    }

    private void assertNotContains(long[] existingLabels, long labelId) {
        if (Arrays.binarySearch(existingLabels, labelId) >= 0) {
            throw new IllegalStateException("Label " + labelId + " already exists on " + this.node);
        }
    }

    public static boolean highHeaderBitSet(byte header) {
        return (header & 8) != 0;
    }

    public Iterable<DynamicRecord> remove(long labelId) {
        long existingLabelsField = this.node.getLabelField();
        byte header = NodeLabelRecordLogic.getHeader(existingLabelsField);
        long existingLabelsBits = NodeLabelRecordLogic.parseLabelsBody(existingLabelsField);
        Collection<DynamicRecord> changedDynamicRecords = Collections.emptyList();
        if (header > 0 && !NodeLabelRecordLogic.highHeaderBitSet(header)) {
            long[] newLabelIds = this.filter(NodeLabelRecordLogic.parseInlined(existingLabelsBits, header), labelId);
            boolean inlined = this.tryInlineInNodeRecord(newLabelIds, changedDynamicRecords);
            assert (inlined);
        } else {
            this.nodeStore.ensureHeavy(this.node, existingLabelsBits);
            Collection<DynamicRecord> existingRecords = this.node.getDynamicLabelRecords();
            long[] existingLabelIds = this.nodeStore.getDynamicLabelsArray(existingRecords);
            long[] newLabelIds = this.filter(existingLabelIds, labelId);
            if (this.tryInlineInNodeRecord(newLabelIds, existingRecords)) {
                for (DynamicRecord record : existingRecords) {
                    record.setInUse(false);
                }
            } else {
                Collection<DynamicRecord> newRecords = this.nodeStore.allocateRecordsForDynamicLabels(newLabelIds, existingRecords.iterator());
                this.node.setLabelField(NodeLabelRecordLogic.dynamicPointer(newRecords), existingRecords);
                if (!newRecords.equals(existingRecords)) {
                    for (DynamicRecord record : existingRecords) {
                        if (newRecords.contains(record)) continue;
                        record.setInUse(false);
                    }
                }
            }
            changedDynamicRecords = existingRecords;
        }
        return changedDynamicRecords;
    }

    public static long parseLabelsBody(long labelsField) {
        return labelsField & 0xFFFFFFFFFL;
    }

    public static long dynamicPointer(Collection<DynamicRecord> newRecords) {
        return 0x8000000000L | IteratorUtil.first(newRecords).getId();
    }

    private long[] filter(long[] ids, long excludeId) {
        boolean found = false;
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] != excludeId) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("Label " + excludeId + " not found on " + this.node);
        }
        long[] result = new long[ids.length - 1];
        int writerIndex = 0;
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == excludeId) continue;
            result[writerIndex++] = ids[i];
        }
        return result;
    }

    private boolean tryInlineInNodeRecord(long[] ids, Collection<DynamicRecord> changedDynamicRecords) {
        if (ids.length > 7) {
            return false;
        }
        byte bitsPerLabel = (byte)(ids.length > 0 ? 36 / ids.length : 36);
        long limit = 1 << bitsPerLabel;
        Bits bits = Bits.bits(5);
        for (long id : ids) {
            if (Long.highestOneBit(id) >= limit) {
                return false;
            }
            bits.put(id, (int)bitsPerLabel);
        }
        this.node.setLabelField(NodeLabelRecordLogic.putHeader(bits.getLongs()[0], (byte)ids.length), changedDynamicRecords);
        return true;
    }

    private long[] concatAndSort(long[] existing, long additional) {
        this.assertNotContains(existing, additional);
        long[] result = new long[existing.length + 1];
        System.arraycopy(existing, 0, result, 0, existing.length);
        result[existing.length] = additional;
        Arrays.sort(result);
        return result;
    }

    public static long[] parseInlined(long existingLabelsField, byte numberOfLabels) {
        if (numberOfLabels == 0) {
            return new long[0];
        }
        byte bitsPerLabel = (byte)(36 / numberOfLabels);
        Bits bits = Bits.bitsFromLongs(new long[]{existingLabelsField});
        long[] result = new long[numberOfLabels];
        for (int i = 0; i < result.length; ++i) {
            result[i] = bits.getLong(bitsPerLabel);
        }
        return result;
    }

    public static byte getHeader(long labelField) {
        return (byte)((labelField & 0xF000000000L) >>> 36);
    }

    public static long putHeader(long labelBits, byte numberOfLabels) {
        return (long)numberOfLabels << 36 | labelBits;
    }
}

