/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.impl.index.IndexXaConnection;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.nioneo.xa.WriteTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnectionHelpImpl;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceHelpImpl;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;

public class NeoStoreXaConnection
extends XaConnectionHelpImpl
implements IndexXaConnection {
    private final NeoStoreXaResource xaResource;
    private final NeoStore neoStore;

    NeoStoreXaConnection(NeoStore neoStore, XaResourceManager xaRm, byte[] branchId) {
        super(xaRm);
        this.neoStore = neoStore;
        this.xaResource = new NeoStoreXaResource(neoStore.getStorageFileName(), xaRm, branchId);
    }

    @Override
    public XAResource getXaResource() {
        return this.xaResource;
    }

    public WriteTransaction getWriteTransaction() {
        try {
            return (WriteTransaction)this.getTransaction();
        }
        catch (XAException e) {
            throw new TransactionFailureException("Unable to get transaction.", e);
        }
    }

    public PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    public RelationshipTypeTokenStore getRelationshipTypeStore() {
        return this.neoStore.getRelationshipTypeStore();
    }

    @Override
    public void createIndex(Class<? extends PropertyContainer> entityType, String indexName, Map<String, String> config) {
    }

    private static class NeoStoreXaResource
    extends XaResourceHelpImpl {
        private final Object identifier;

        NeoStoreXaResource(Object identifier, XaResourceManager xaRm, byte[] branchId) {
            super(xaRm, branchId);
            this.identifier = identifier;
        }

        @Override
        public boolean isSameRM(XAResource xares) {
            if (xares instanceof NeoStoreXaResource) {
                return this.identifier.equals(((NeoStoreXaResource)xares).identifier);
            }
            return false;
        }
    }
}

