/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.ByteBuffer;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.RecordSerializable;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;

public interface SchemaRule
extends RecordSerializable {
    public long getId();

    public long getLabel();

    public Kind getKind();

    public static abstract class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind INDEX_RULE = new Kind(1, IndexRule.class){

            @Override
            protected SchemaRule newRule(long id, long labelId, ByteBuffer buffer) {
                return IndexRule.readIndexRule(id, false, labelId, buffer);
            }
        };
        public static final /* enum */ Kind CONSTRAINT_INDEX_RULE = new Kind(2, IndexRule.class){

            @Override
            protected SchemaRule newRule(long id, long labelId, ByteBuffer buffer) {
                return IndexRule.readIndexRule(id, true, labelId, buffer);
            }
        };
        public static final /* enum */ Kind UNIQUENESS_CONSTRAINT = new Kind(3, UniquenessConstraintRule.class){

            @Override
            protected SchemaRule newRule(long id, long labelId, ByteBuffer buffer) {
                return UniquenessConstraintRule.readUniquenessConstraintRule(id, labelId, buffer);
            }
        };
        private final byte id;
        private final Class<? extends SchemaRule> ruleClass;
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        private Kind(int id, Class<? extends SchemaRule> ruleClass) {
            assert (id > 0) : "Kind id 0 is reserved";
            this.id = (byte)id;
            this.ruleClass = ruleClass;
        }

        public Class<? extends SchemaRule> getRuleClass() {
            return this.ruleClass;
        }

        public byte id() {
            return this.id;
        }

        protected abstract SchemaRule newRule(long var1, long var3, ByteBuffer var5);

        public static SchemaRule deserialize(long id, ByteBuffer buffer) {
            long labelId = buffer.getInt();
            Kind kind = Kind.kindForId(buffer.get());
            try {
                return kind.newRule(id, labelId, buffer);
            }
            catch (Exception e) {
                throw Exceptions.launderedException(e);
            }
        }

        public static Kind kindForId(byte id) {
            switch (id) {
                case 1: {
                    return INDEX_RULE;
                }
                case 2: {
                    return CONSTRAINT_INDEX_RULE;
                }
                case 3: {
                    return UNIQUENESS_CONSTRAINT;
                }
            }
            throw new IllegalArgumentException("Unknown kind id " + id);
        }

        public boolean isIndex() {
            return this.ruleClass == IndexRule.class;
        }

        static {
            $VALUES = new Kind[]{INDEX_RULE, CONSTRAINT_INDEX_RULE, UNIQUENESS_CONSTRAINT};
        }
    }
}

