/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.TransactionContext;
import org.neo4j.kernel.api.exceptions.BeginTransactionFailureException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.TransactionalException;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;

public class Transactor {
    private final AbstractTransactionManager txManager;

    public Transactor(AbstractTransactionManager txManager) {
        this.txManager = txManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RESULT, FAILURE extends KernelException> RESULT execute(Statement<RESULT, FAILURE> statement) throws FAILURE, TransactionalException {
        Transaction previousTransaction = this.suspendTransaction();
        try {
            RESULT RESULT;
            block16: {
                TransactionContext tx;
                block15: {
                    this.beginTransaction();
                    tx = this.txManager.getTransactionContext();
                    boolean success = false;
                    try {
                        RESULT result;
                        StatementContext context = tx.newStatementContext();
                        try {
                            result = statement.perform(context);
                        }
                        finally {
                            context.close();
                        }
                        success = true;
                        RESULT = result;
                        if (!success) break block15;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (success) {
                                tx.commit();
                            } else {
                                tx.rollback();
                            }
                            throw throwable;
                        }
                        catch (TransactionalException failure) {
                            previousTransaction = null;
                            throw failure;
                        }
                    }
                    tx.commit();
                    break block16;
                }
                tx.rollback();
            }
            return RESULT;
        }
        finally {
            if (previousTransaction != null) {
                this.resumeTransaction(previousTransaction);
            }
        }
    }

    private void beginTransaction() throws BeginTransactionFailureException {
        try {
            this.txManager.begin();
        }
        catch (NotSupportedException e) {
            throw new BeginTransactionFailureException((Exception)((Object)e));
        }
        catch (SystemException e) {
            throw new BeginTransactionFailureException((Exception)((Object)e));
        }
    }

    private Transaction suspendTransaction() throws TransactionFailureException {
        Transaction existingTransaction;
        try {
            existingTransaction = this.txManager.suspend();
        }
        catch (SystemException failure) {
            throw new TransactionFailureException(failure);
        }
        return existingTransaction;
    }

    private void resumeTransaction(Transaction existingTransaction) throws TransactionFailureException {
        try {
            this.txManager.resume(existingTransaction);
        }
        catch (InvalidTransactionException failure) {
            throw new ThisShouldNotHappenError("Tobias Lindaaker", "Transaction resumed in the same transaction manager as it was suspended from should not be invalid. The Neo4j code base does not throw InvalidTransactionException", failure);
        }
        catch (SystemException failure) {
            throw new TransactionFailureException(failure);
        }
    }

    public static interface Statement<RESULT, FAILURE extends KernelException> {
        public RESULT perform(StatementContext var1) throws FAILURE;
    }
}

