/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.Transaction;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;

public class LockHolder {
    private final LockManager lockManager;
    private final Transaction tx;
    private final List<Releasable> locks = new ArrayList<Releasable>();

    public LockHolder(LockManager lockManager, Transaction tx) {
        if (tx == null) {
            throw new RuntimeException("Cannot initialize lock holder without a transaction, got null.");
        }
        this.lockManager = lockManager;
        this.tx = tx;
    }

    public void acquireNodeReadLock(long nodeId) {
        NodeLock resource = new NodeLock(LockType.READ, nodeId);
        this.lockManager.getReadLock(resource, this.tx);
        this.locks.add(resource);
    }

    public void acquireNodeWriteLock(long nodeId) {
        NodeLock resource = new NodeLock(LockType.WRITE, nodeId);
        this.lockManager.getWriteLock(resource, this.tx);
        this.locks.add(resource);
    }

    public void acquireSchemaReadLock() {
        SchemaLock resource = new SchemaLock(LockType.READ);
        this.lockManager.getReadLock(resource, this.tx);
        this.locks.add(resource);
    }

    public void acquireSchemaWriteLock() {
        SchemaLock resource = new SchemaLock(LockType.WRITE);
        this.lockManager.getWriteLock(resource, this.tx);
        this.locks.add(resource);
    }

    public void releaseLocks() {
        ArrayList<Releasable> releaseFailures = null;
        Exception releaseException = null;
        for (Releasable lockElement : this.locks) {
            try {
                lockElement.release();
            }
            catch (Exception e) {
                releaseException = e;
                if (releaseFailures == null) {
                    releaseFailures = new ArrayList<Releasable>();
                }
                releaseFailures.add(lockElement);
            }
        }
        if (releaseException != null) {
            throw new RuntimeException("Unable to release locks: " + releaseFailures + ".", releaseException);
        }
    }

    class SchemaLock
    extends Releasable {
        private final org.neo4j.kernel.impl.core.SchemaLock actual;

        public SchemaLock(LockType lockType) {
            super(lockType);
            this.actual = new org.neo4j.kernel.impl.core.SchemaLock();
        }

        public int hashCode() {
            return this.actual.hashCode();
        }

        public boolean equals(Object obj) {
            return this.actual.equals(obj);
        }
    }

    private class NodeLock
    extends Releasable
    implements Node {
        private final long id;

        public NodeLock(LockType lockType, long id) {
            super(lockType);
            this.id = id;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Node)) {
                return false;
            }
            return this.getId() == ((Node)o).getId();
        }

        public int hashCode() {
            return (int)(this.id >>> 32 ^ this.id);
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public void delete() {
            throw this.unsupportedOperation();
        }

        @Override
        public Iterable<Relationship> getRelationships() {
            throw this.unsupportedOperation();
        }

        @Override
        public boolean hasRelationship() {
            throw this.unsupportedOperation();
        }

        @Override
        public Iterable<Relationship> getRelationships(RelationshipType ... types) {
            throw this.unsupportedOperation();
        }

        @Override
        public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
            throw this.unsupportedOperation();
        }

        @Override
        public boolean hasRelationship(RelationshipType ... types) {
            throw this.unsupportedOperation();
        }

        @Override
        public boolean hasRelationship(Direction direction, RelationshipType ... types) {
            throw this.unsupportedOperation();
        }

        @Override
        public Iterable<Relationship> getRelationships(Direction dir) {
            throw this.unsupportedOperation();
        }

        @Override
        public boolean hasRelationship(Direction dir) {
            throw this.unsupportedOperation();
        }

        @Override
        public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
            throw this.unsupportedOperation();
        }

        @Override
        public boolean hasRelationship(RelationshipType type, Direction dir) {
            throw this.unsupportedOperation();
        }

        @Override
        public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
            throw this.unsupportedOperation();
        }

        @Override
        public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
            throw this.unsupportedOperation();
        }

        @Override
        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
            throw this.unsupportedOperation();
        }

        @Override
        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
            throw this.unsupportedOperation();
        }

        @Override
        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
            throw this.unsupportedOperation();
        }

        @Override
        public void addLabel(Label label) {
            throw this.unsupportedOperation();
        }

        @Override
        public void removeLabel(Label label) {
            throw this.unsupportedOperation();
        }

        @Override
        public boolean hasLabel(Label label) {
            throw this.unsupportedOperation();
        }

        @Override
        public GraphDatabaseService getGraphDatabase() {
            throw this.unsupportedOperation();
        }

        @Override
        public boolean hasProperty(String key) {
            throw this.unsupportedOperation();
        }

        @Override
        public Object getProperty(String key) {
            throw this.unsupportedOperation();
        }

        @Override
        public Object getProperty(String key, Object defaultValue) {
            throw this.unsupportedOperation();
        }

        @Override
        public void setProperty(String key, Object value) {
            throw this.unsupportedOperation();
        }

        @Override
        public Object removeProperty(String key) {
            throw this.unsupportedOperation();
        }

        @Override
        public Iterable<String> getPropertyKeys() {
            throw this.unsupportedOperation();
        }

        @Override
        public Iterable<Object> getPropertyValues() {
            throw this.unsupportedOperation();
        }

        @Override
        public ResourceIterable<Label> getLabels() {
            throw this.unsupportedOperation();
        }

        private UnsupportedOperationException unsupportedOperation() {
            return new UnsupportedOperationException("NodeLock does not support this operation.");
        }
    }

    private abstract class Releasable {
        private final LockType lockType;

        public Releasable(LockType lockType) {
            this.lockType = lockType;
        }

        public void release() {
            this.lockType.release(LockHolder.this.lockManager, this, LockHolder.this.tx);
        }
    }
}

