/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;

public interface IndexReaderFactory {
    public IndexReader newReader(long var1) throws IndexNotFoundKernelException;

    public void close();

    public static class Caching
    implements IndexReaderFactory {
        private Map<Long, IndexReader> indexReaders = null;
        private final IndexingService indexingService;

        public Caching(IndexingService indexingService) {
            this.indexingService = indexingService;
        }

        @Override
        public IndexReader newReader(long indexId) throws IndexNotFoundKernelException {
            IndexReader reader;
            if (this.indexReaders == null) {
                this.indexReaders = new HashMap<Long, IndexReader>();
            }
            if ((reader = this.indexReaders.get(indexId)) == null) {
                IndexProxy index = this.indexingService.getProxyForRule(indexId);
                reader = index.newReader();
                this.indexReaders.put(indexId, reader);
            }
            return reader;
        }

        @Override
        public void close() {
            if (this.indexReaders != null) {
                for (IndexReader indexReader : this.indexReaders.values()) {
                    indexReader.close();
                }
            }
        }
    }
}

