/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.schema.AddIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.IndexBelongsToConstraintException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchIndexException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.impl.api.CompositeStatementContext;
import org.neo4j.kernel.impl.api.ConstraintCreationKernelException;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;

public class DataIntegrityValidatingStatementContext
extends CompositeStatementContext {
    private final StatementContext delegate;

    public DataIntegrityValidatingStatementContext(StatementContext delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    public long propertyKeyGetOrCreateForName(String propertyKey) throws SchemaKernelException {
        if (propertyKey == null) {
            throw new IllegalTokenNameException(null);
        }
        return this.delegate.propertyKeyGetOrCreateForName(propertyKey);
    }

    @Override
    public long labelGetOrCreateForName(String label) throws SchemaKernelException {
        if (label == null || label.length() == 0) {
            throw new IllegalTokenNameException(label);
        }
        return this.delegate.labelGetOrCreateForName(label);
    }

    @Override
    public IndexDescriptor indexCreate(long labelId, long propertyKey) throws SchemaKernelException {
        try {
            this.checkIndexExistence(labelId, propertyKey);
        }
        catch (KernelException e) {
            throw new AddIndexFailureException(labelId, propertyKey, e);
        }
        return this.delegate.indexCreate(labelId, propertyKey);
    }

    @Override
    public IndexDescriptor uniqueIndexCreate(long labelId, long propertyKey) throws SchemaKernelException {
        try {
            this.checkIndexExistence(labelId, propertyKey);
        }
        catch (KernelException e) {
            throw new AddIndexFailureException(labelId, propertyKey, e);
        }
        return this.delegate.uniqueIndexCreate(labelId, propertyKey);
    }

    private void checkIndexExistence(long labelId, long propertyKey) throws SchemaKernelException {
        for (IndexDescriptor descriptor : IteratorUtil.loop(this.indexesGetForLabel(labelId))) {
            if (descriptor.getPropertyKeyId() != propertyKey) continue;
            throw new AlreadyIndexedException(descriptor);
        }
        for (IndexDescriptor descriptor : IteratorUtil.loop(this.uniqueIndexesGetForLabel(labelId))) {
            if (descriptor.getPropertyKeyId() != propertyKey) continue;
            throw new AlreadyConstrainedException(new UniquenessConstraint(descriptor.getLabelId(), descriptor.getPropertyKeyId()));
        }
    }

    @Override
    public void indexDrop(IndexDescriptor descriptor) throws DropIndexFailureException {
        try {
            this.assertIsNotUniqueIndex(descriptor, this.uniqueIndexesGetForLabel(descriptor.getLabelId()));
            this.assertIndexExists(descriptor, this.indexesGetForLabel(descriptor.getLabelId()));
        }
        catch (SchemaKernelException e) {
            throw new DropIndexFailureException(descriptor, e);
        }
        this.delegate.indexDrop(descriptor);
    }

    private void assertIsNotUniqueIndex(IndexDescriptor descriptor, Iterator<IndexDescriptor> uniqueIndexes) throws IndexBelongsToConstraintException {
        while (uniqueIndexes.hasNext()) {
            IndexDescriptor uniqueIndex = uniqueIndexes.next();
            if (uniqueIndex.getPropertyKeyId() != descriptor.getPropertyKeyId()) continue;
            throw new IndexBelongsToConstraintException(descriptor);
        }
    }

    @Override
    public void uniqueIndexDrop(IndexDescriptor descriptor) throws DropIndexFailureException {
        try {
            this.assertIndexExists(descriptor, this.uniqueIndexesGetForLabel(descriptor.getLabelId()));
        }
        catch (NoSuchIndexException e) {
            throw new DropIndexFailureException(descriptor, e);
        }
        this.delegate.uniqueIndexDrop(descriptor);
    }

    @Override
    public UniquenessConstraint uniquenessConstraintCreate(long labelId, long propertyKey) throws SchemaKernelException, ConstraintCreationKernelException {
        Iterator<UniquenessConstraint> constraints = this.constraintsGetForLabelAndPropertyKey(labelId, propertyKey);
        if (constraints.hasNext()) {
            throw new AlreadyConstrainedException(constraints.next());
        }
        return this.delegate.uniquenessConstraintCreate(labelId, propertyKey);
    }

    private void assertIndexExists(IndexDescriptor descriptor, Iterator<IndexDescriptor> indexes) throws NoSuchIndexException {
        for (IndexDescriptor existing : IteratorUtil.loop(indexes)) {
            if (existing.getPropertyKeyId() != descriptor.getPropertyKeyId()) continue;
            return;
        }
        throw new NoSuchIndexException(descriptor);
    }
}

