/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public abstract class SchemaIndexProvider
extends LifecycleAdapter
implements Comparable<SchemaIndexProvider> {
    public static final SchemaIndexProvider NO_INDEX_PROVIDER = new SchemaIndexProvider(new Descriptor("no-index-provider", "1.0"), -1){
        private final IndexAccessor singleWriter = new IndexAccessor.Adapter();
        private final IndexPopulator singlePopulator = new IndexPopulator.Adapter();

        @Override
        public IndexAccessor getOnlineAccessor(long indexId, IndexConfiguration config) {
            return this.singleWriter;
        }

        @Override
        public IndexPopulator getPopulator(long indexId, IndexConfiguration config) {
            return this.singlePopulator;
        }

        @Override
        public InternalIndexState getInitialState(long indexId) {
            return InternalIndexState.POPULATING;
        }
    };
    public static final DependencyResolver.SelectionStrategy<SchemaIndexProvider> HIGHEST_PRIORITIZED_OR_NONE = new DependencyResolver.SelectionStrategy<SchemaIndexProvider>(){

        @Override
        public SchemaIndexProvider select(Class<SchemaIndexProvider> type, Iterable<SchemaIndexProvider> candidates) throws IllegalArgumentException {
            List all = IteratorUtil.addToCollection(candidates, new ArrayList());
            if (all.isEmpty()) {
                return NO_INDEX_PROVIDER;
            }
            Collections.sort(all);
            return (SchemaIndexProvider)all.get(all.size() - 1);
        }
    };
    private final int priority;
    private final Descriptor providerDescriptor;

    protected SchemaIndexProvider(Descriptor descriptor, int priority) {
        assert (descriptor != null);
        this.priority = priority;
        this.providerDescriptor = descriptor;
    }

    public abstract IndexPopulator getPopulator(long var1, IndexConfiguration var3);

    public abstract IndexAccessor getOnlineAccessor(long var1, IndexConfiguration var3) throws IOException;

    public abstract InternalIndexState getInitialState(long var1);

    public Descriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    @Override
    public int compareTo(SchemaIndexProvider o) {
        return this.priority - o.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaIndexProvider other = (SchemaIndexProvider)o;
        return this.priority == other.priority && this.providerDescriptor.equals(other.providerDescriptor);
    }

    public int hashCode() {
        int result = this.priority;
        result = 31 * result + (this.providerDescriptor != null ? this.providerDescriptor.hashCode() : 0);
        return result;
    }

    protected File getRootDirectory(Config config, String key) {
        return new File(new File(new File(config.get(GraphDatabaseSettings.store_dir), "schema"), "index"), key);
    }

    public static class Descriptor {
        private final String key;
        private final String version;

        public Descriptor(String key, String version) {
            if (key == null) {
                throw new IllegalArgumentException("null provider key prohibited");
            }
            if (key.length() == 0) {
                throw new IllegalArgumentException("empty provider key prohibited");
            }
            if (version == null) {
                throw new IllegalArgumentException("null provider version prohibited");
            }
            this.key = key;
            this.version = version;
        }

        public String getKey() {
            return this.key;
        }

        public String getVersion() {
            return this.version;
        }

        public int hashCode() {
            return 23 + this.key.hashCode() ^ this.version.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof Descriptor) {
                Descriptor otherDescriptor = (Descriptor)obj;
                return this.key.equals(otherDescriptor.getKey()) && this.version.equals(otherDescriptor.getVersion());
            }
            return false;
        }

        public String toString() {
            return "{key=" + this.key + ", version=" + this.version + "}";
        }
    }
}

