/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Collections;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.UniquenessConstraintDefinition;
import org.neo4j.kernel.BaseConstraintDefinition;
import org.neo4j.kernel.InternalSchemaActions;

public class PropertyUniqueConstraintDefinition
extends BaseConstraintDefinition
implements UniquenessConstraintDefinition {
    private final String propertyKey;

    public PropertyUniqueConstraintDefinition(InternalSchemaActions actions, Label label, String propertyKey) {
        super(actions, label);
        this.propertyKey = propertyKey;
    }

    @Override
    public ConstraintType getConstraintType() {
        return ConstraintType.UNIQUENESS;
    }

    @Override
    public void drop() {
        this.actions.dropPropertyUniquenessConstraint(this.label, this.propertyKey);
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return Collections.singletonList(this.propertyKey);
    }

    @Override
    public UniquenessConstraintDefinition asUniquenessConstraint() {
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.propertyKey == null ? 0 : this.propertyKey.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyUniqueConstraintDefinition other = (PropertyUniqueConstraintDefinition)obj;
        return !(this.propertyKey == null ? other.propertyKey != null : !this.propertyKey.equals(other.propertyKey));
    }

    public String toString() {
        return String.format("%s.%s IS UNIQUE", this.label.name().toLowerCase(), this.propertyKey);
    }
}

