/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.unsafe.batchinsert.PropertyIndexHolder;

class LabelHolder {
    private final PropertyIndexHolder indexHolder;
    private final Map<Long, Label> labelInstances = new HashMap<Long, Label>();

    LabelHolder(PropertyIndexHolder indexHolder) {
        this.indexHolder = indexHolder;
    }

    long getKeyId(Label label) {
        return this.indexHolder.getKeyId(label.name());
    }

    Label getLabel(long keyId) {
        Label label = this.labelInstances.get(keyId);
        if (label == null) {
            label = DynamicLabel.label(this.indexHolder.getStringKey((int)keyId));
            this.labelInstances.put(keyId, label);
        }
        return label;
    }
}

