/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.IndexDefinition;

public class BatchIndexDefinition
implements IndexDefinition {
    private final Label label;
    private final Collection<String> propertyKeys;

    public BatchIndexDefinition(Label label, String ... propertyKeys) {
        this.label = label;
        this.propertyKeys = new ArrayList<String>();
        for (String propertyKey : propertyKeys) {
            this.propertyKeys.add(propertyKey);
        }
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return Collections.unmodifiableCollection(this.propertyKeys);
    }

    @Override
    public void drop() {
        throw new UnsupportedOperationException("Dropping schema indexes is not supported in batch mode");
    }
}

