/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;

public class LegacyStore
implements Closeable {
    public static final String LEGACY_VERSION = "v0.A.0";
    private final File storageFileName;
    private LegacyNodeStoreReader nodeStoreReader;
    private final Collection<Closeable> allStoreReaders = new ArrayList<Closeable>();
    private final FileSystemAbstraction fs;

    public LegacyStore(FileSystemAbstraction fs, File storageFileName) throws IOException {
        this.fs = fs;
        this.storageFileName = storageFileName;
        LegacyStore.assertLegacyAndCurrentVersionHaveSameLength(LEGACY_VERSION, "v0.A.1");
        this.initStorage();
    }

    static void assertLegacyAndCurrentVersionHaveSameLength(String legacyVersion, String currentVersion) {
        if (UTF8.encode(legacyVersion).length != UTF8.encode(currentVersion).length) {
            throw new IllegalStateException("Encoded version string length must remain the same between versions");
        }
    }

    protected void initStorage() throws IOException {
        this.nodeStoreReader = new LegacyNodeStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".nodestore.db"));
        this.allStoreReaders.add(this.nodeStoreReader);
    }

    public File getStorageFileName() {
        return this.storageFileName;
    }

    public static long getUnsignedInt(ByteBuffer buf) {
        return (long)buf.getInt() & 0xFFFFFFFFL;
    }

    protected static long longFromIntAndMod(long base, long modifier) {
        return modifier == 0L && base == 0xFFFFFFFFL ? -1L : base | modifier;
    }

    @Override
    public void close() throws IOException {
        for (Closeable storeReader : this.allStoreReaders) {
            storeReader.close();
        }
    }

    private void copyStore(File targetBaseStorageFileName, String storeNamePart, String versionTrailer) throws IOException {
        File targetStoreFileName = new File(targetBaseStorageFileName.getPath() + storeNamePart);
        this.fs.copyFile(new File(this.storageFileName + storeNamePart), targetStoreFileName);
        this.setStoreVersionTrailer(targetStoreFileName, versionTrailer);
        this.fs.copyFile(new File(this.storageFileName + storeNamePart + ".id"), new File(targetBaseStorageFileName + storeNamePart + ".id"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStoreVersionTrailer(File targetStoreFileName, String versionTrailer) throws IOException {
        FileChannel fileChannel = this.fs.open(targetStoreFileName, "rw");
        try {
            byte[] trailer = UTF8.encode(versionTrailer);
            fileChannel.position(fileChannel.size() - (long)trailer.length);
            fileChannel.write(ByteBuffer.wrap(trailer));
        }
        finally {
            fileChannel.close();
        }
    }

    public void copyNeoStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), "", neoStore.getTypeAndVersionDescriptor());
    }

    public void copyRelationshipStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".relationshipstore.db", CommonAbstractStore.buildTypeDescriptorAndVersion("RelationshipStore"));
    }

    public void copyRelationshipTypeStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".relationshiptypestore.db", CommonAbstractStore.buildTypeDescriptorAndVersion("RelationshipTypeStore"));
    }

    public void copyRelationshipTypeNameStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".relationshiptypestore.db.names", CommonAbstractStore.buildTypeDescriptorAndVersion("StringPropertyStore"));
    }

    public void copyPropertyStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".propertystore.db", CommonAbstractStore.buildTypeDescriptorAndVersion("PropertyStore"));
    }

    public void copyPropertyIndexStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".propertystore.db.index", CommonAbstractStore.buildTypeDescriptorAndVersion("PropertyIndexStore"));
    }

    public void copyPropertyIndexNameStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".propertystore.db.index.keys", CommonAbstractStore.buildTypeDescriptorAndVersion("StringPropertyStore"));
    }

    public void copyDynamicStringPropertyStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".propertystore.db.strings", CommonAbstractStore.buildTypeDescriptorAndVersion("StringPropertyStore"));
    }

    public void copyDynamicArrayPropertyStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".propertystore.db.arrays", CommonAbstractStore.buildTypeDescriptorAndVersion("ArrayPropertyStore"));
    }

    public LegacyNodeStoreReader getNodeStoreReader() {
        return this.nodeStoreReader;
    }
}

