/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.storemigration.DatabaseFiles;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.UpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.util.StringLogger;

public class StoreUpgrader {
    private final Config originalConfig;
    private final UpgradeConfiguration upgradeConfiguration;
    private final UpgradableDatabase upgradableDatabase;
    private final StoreMigrator storeMigrator;
    private final DatabaseFiles databaseFiles;
    private final IdGeneratorFactory idGeneratorFactory;
    private final FileSystemAbstraction fileSystem;

    public StoreUpgrader(Config originalConfig, UpgradeConfiguration upgradeConfiguration, UpgradableDatabase upgradableDatabase, StoreMigrator storeMigrator, DatabaseFiles databaseFiles, IdGeneratorFactory idGeneratorFactory, FileSystemAbstraction fileSystem) {
        this.idGeneratorFactory = idGeneratorFactory;
        this.fileSystem = fileSystem;
        this.originalConfig = originalConfig;
        this.upgradeConfiguration = upgradeConfiguration;
        this.upgradableDatabase = upgradableDatabase;
        this.storeMigrator = storeMigrator;
        this.databaseFiles = databaseFiles;
    }

    public void attemptUpgrade(File storageFileName) {
        this.upgradeConfiguration.checkConfigurationAllowsAutomaticUpgrade();
        this.upgradableDatabase.checkUpgradeable(storageFileName);
        File workingDirectory = storageFileName.getParentFile();
        File upgradeDirectory = new File(workingDirectory, "upgrade");
        File backupDirectory = new File(workingDirectory, "upgrade_backup");
        this.migrateToIsolatedDirectory(storageFileName, upgradeDirectory);
        this.databaseFiles.moveToBackupDirectory(workingDirectory, backupDirectory);
        this.backupMessagesLogLeavingInPlaceForNewDatabaseMessages(workingDirectory, backupDirectory);
        this.databaseFiles.moveToWorkingDirectory(upgradeDirectory, workingDirectory);
    }

    private void backupMessagesLogLeavingInPlaceForNewDatabaseMessages(File workingDirectory, File backupDirectory) {
        try {
            File originalLog = new File(workingDirectory, "messages.log");
            if (this.fileSystem.fileExists(originalLog)) {
                this.fileSystem.copyFile(originalLog, new File(backupDirectory, "messages.log"));
            }
        }
        catch (IOException e) {
            throw new UnableToUpgradeException(e);
        }
    }

    private void migrateToIsolatedDirectory(File storageFileName, File upgradeDirectory) {
        if (upgradeDirectory.exists()) {
            try {
                this.fileSystem.deleteRecursively(upgradeDirectory);
            }
            catch (IOException e) {
                throw new UnableToUpgradeException(e);
            }
        }
        this.fileSystem.mkdir(upgradeDirectory);
        File upgradeFileName = new File(upgradeDirectory, "neostore");
        HashMap<String, String> upgradeConfig = new HashMap<String, String>(this.originalConfig.getParams());
        upgradeConfig.put("neo_store", upgradeFileName.getPath());
        Config upgradeConfiguration = new Config(upgradeConfig);
        NeoStore neoStore = new StoreFactory(upgradeConfiguration, this.idGeneratorFactory, new DefaultWindowPoolFactory(), this.fileSystem, StringLogger.DEV_NULL, null).createNeoStore(upgradeFileName);
        try {
            this.storeMigrator.migrate(new LegacyStore(this.fileSystem, storageFileName), neoStore);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UnableToUpgradeException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw Exceptions.launderedException(e);
        }
        finally {
            neoStore.close();
        }
    }

    public static class UnableToUpgradeException
    extends RuntimeException {
        public UnableToUpgradeException(Exception cause) {
            super(cause);
        }

        public UnableToUpgradeException(String message) {
            super(message);
        }
    }
}

