/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.ByteBuffer;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.nioneo.store.AbstractSchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;

public class IndexRule
extends AbstractSchemaRule {
    private final SchemaIndexProvider.Descriptor providerDescriptor;
    private final long propertyKey;

    public IndexRule(long id, long label, ByteBuffer serialized) {
        this(id, label, IndexRule.readProviderDescriptor(serialized), IndexRule.readPropertyKey(serialized));
    }

    public IndexRule(long id, long label, SchemaIndexProvider.Descriptor providerDescriptor, long propertyKey) {
        super(id, label, SchemaRule.Kind.INDEX_RULE);
        if (providerDescriptor == null) {
            throw new IllegalArgumentException("null provider descriptor prohibited");
        }
        this.providerDescriptor = providerDescriptor;
        this.propertyKey = propertyKey;
    }

    private static SchemaIndexProvider.Descriptor readProviderDescriptor(ByteBuffer serialized) {
        String providerKey = UTF8.getDecodedStringFrom(serialized);
        String providerVersion = UTF8.getDecodedStringFrom(serialized);
        return new SchemaIndexProvider.Descriptor(providerKey, providerVersion);
    }

    private static long readPropertyKey(ByteBuffer serialized) {
        short count = serialized.getShort();
        assert (count == 1);
        return serialized.getLong();
    }

    public SchemaIndexProvider.Descriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    public long getPropertyKey() {
        return this.propertyKey;
    }

    @Override
    public int length() {
        return super.length() + UTF8.computeRequiredByteBufferSize(this.providerDescriptor.getKey()) + UTF8.computeRequiredByteBufferSize(this.providerDescriptor.getVersion()) + 2 + 8;
    }

    @Override
    public void serialize(ByteBuffer target) {
        super.serialize(target);
        UTF8.putEncodedStringInto(this.providerDescriptor.getKey(), target);
        UTF8.putEncodedStringInto(this.providerDescriptor.getVersion(), target);
        target.putShort((short)1);
        target.putLong(this.propertyKey);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (int)this.propertyKey;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexRule other = (IndexRule)obj;
        return this.propertyKey == other.propertyKey;
    }

    @Override
    protected String innerToString() {
        return ", provider=" + this.providerDescriptor + ", properties=" + this.propertyKey;
    }
}

