/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.core.ArrayBasedPrimitive;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.util.ArrayMap;

public class RelationshipImpl
extends ArrayBasedPrimitive {
    private final long idAndMore;
    private final int startNodeId;
    private final int endNodeId;

    RelationshipImpl(long id, long startNodeId, long endNodeId, int typeId, boolean newRel) {
        super(newRel);
        this.startNodeId = (int)startNodeId;
        this.endNodeId = (int)endNodeId;
        this.idAndMore = (long)typeId << 48 | (startNodeId & 0xF00000000L) << 12 | (endNodeId & 0xF00000000L) << 8 | id;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RelationshipImpl && ((RelationshipImpl)obj).getId() == this.getId();
    }

    @Override
    protected PropertyData changeProperty(NodeManager nodeManager, PropertyData property, Object value, TransactionState tx) {
        return nodeManager.relChangeProperty(this, property, value, tx);
    }

    @Override
    protected PropertyData addProperty(NodeManager nodeManager, PropertyIndex index, Object value) {
        return nodeManager.relAddProperty(this, index, value);
    }

    @Override
    public int size() {
        return super.size() + 8 + 8;
    }

    @Override
    protected void removeProperty(NodeManager nodeManager, PropertyData property, TransactionState tx) {
        nodeManager.relRemoveProperty(this, property, tx);
    }

    @Override
    protected ArrayMap<Integer, PropertyData> loadProperties(NodeManager nodeManager, boolean light) {
        return nodeManager.loadProperties(this, light);
    }

    @Override
    public long getId() {
        return this.idAndMore & 0xFFFFFFFFFFL;
    }

    long getStartNodeId() {
        return (long)this.startNodeId & 0xFFFFFFFFL | (this.idAndMore & 0xF00000000000L) >> 12;
    }

    long getEndNodeId() {
        return (long)this.endNodeId & 0xFFFFFFFFL | (this.idAndMore & 0xF0000000000L) >> 8;
    }

    int getTypeId() {
        return (int)((this.idAndMore & 0xFFFF000000000000L) >>> 48);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(NodeManager nodeManager, Relationship proxy) {
        boolean success = false;
        try {
            NodeImpl endNode;
            TransactionState tx = nodeManager.getTransactionState();
            NodeImpl startNode = nodeManager.getLightNode(this.getStartNodeId());
            if (startNode != null) {
                tx.acquireWriteLock(nodeManager.newNodeProxyById(this.getStartNodeId()));
            }
            if ((endNode = nodeManager.getLightNode(this.getEndNodeId())) != null) {
                tx.acquireWriteLock(nodeManager.newNodeProxyById(this.getEndNodeId()));
            }
            tx.acquireWriteLock(proxy);
            ArrayMap<Integer, PropertyData> skipMap = tx.getOrCreateCowPropertyRemoveMap(this);
            ArrayMap<Integer, PropertyData> removedProps = nodeManager.deleteRelationship(this, tx);
            if (removedProps.size() > 0) {
                for (int index : removedProps.keySet()) {
                    skipMap.put(index, removedProps.get(index));
                }
            }
            success = true;
            int typeId = this.getTypeId();
            long id = this.getId();
            if (startNode != null) {
                tx.getOrCreateCowRelationshipRemoveMap(startNode, typeId).add(id);
            }
            if (endNode != null) {
                tx.getOrCreateCowRelationshipRemoveMap(endNode, typeId).add(id);
            }
            success = true;
        }
        finally {
            if (!success) {
                nodeManager.setRollbackOnly();
            }
        }
    }

    public String toString() {
        return "RelationshipImpl #" + this.getId() + " of type " + this.getTypeId() + " between Node[" + this.getStartNodeId() + "] and Node[" + this.getEndNodeId() + "]";
    }

    @Override
    public WritableTransactionState.CowEntityElement getEntityElement(WritableTransactionState.PrimitiveElement element, boolean create) {
        return element.relationshipElement(this.getId(), create);
    }

    @Override
    PropertyContainer asProxy(NodeManager nm) {
        return nm.newRelationshipProxyById(this.getId());
    }

    @Override
    protected void updateSize(NodeManager nodeManager) {
        nodeManager.updateCacheSize(this, this.size());
    }
}

