/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Map;
import org.neo4j.kernel.impl.core.KeyCreator;
import org.neo4j.kernel.impl.core.KeyHolder;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;

public class PropertyIndexManager
extends KeyHolder<PropertyIndex> {
    private static final PropertyIndex[] EMPTY_PROPERTY_INDEXES = new PropertyIndex[0];
    private final Map<String, PropertyIndex[]> indexMap = new CopyOnWriteHashMap<String, PropertyIndex[]>();

    public PropertyIndexManager(AbstractTransactionManager txManager, PersistenceManager persistenceManager, EntityIdGenerator idGenerator, KeyCreator keyCreator) {
        super(txManager, persistenceManager, idGenerator, keyCreator);
    }

    @Override
    public void stop() {
        super.stop();
        this.indexMap.clear();
    }

    public PropertyIndex[] index(String key) {
        PropertyIndex[] existing = null;
        if (key != null) {
            existing = this.indexMap.get(key);
        }
        if (existing == null) {
            existing = EMPTY_PROPERTY_INDEXES;
        }
        return existing;
    }

    @Override
    protected void addKeyEntry(String name, int id) {
        super.addKeyEntry(name, id);
        PropertyIndex[] list = this.indexMap.get(name);
        PropertyIndex key = this.newKey(name, id);
        if (list == null) {
            list = new PropertyIndex[]{key};
        } else {
            PropertyIndex[] extendedList = new PropertyIndex[list.length + 1];
            System.arraycopy(list, 0, extendedList, 0, list.length);
            extendedList[list.length] = key;
            list = extendedList;
        }
        this.indexMap.put(name, list);
    }

    @Override
    protected PropertyIndex newKey(String key, int id) {
        return new PropertyIndex(key, id);
    }

    @Override
    protected String nameOf(PropertyIndex key) {
        return key.getKey();
    }
}

