/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Map;
import org.neo4j.kernel.impl.core.KeyCreator;
import org.neo4j.kernel.impl.core.KeyNotFoundException;
import org.neo4j.kernel.impl.nioneo.store.NameData;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public abstract class KeyHolder<KEY>
extends LifecycleAdapter {
    private Map<String, Integer> keyToId = new CopyOnWriteHashMap<String, Integer>();
    private Map<Integer, KEY> idToKey = new CopyOnWriteHashMap<Integer, KEY>();
    private final AbstractTransactionManager transactionManager;
    protected final PersistenceManager persistenceManager;
    private final EntityIdGenerator idGenerator;
    private final KeyCreator keyCreator;

    public KeyHolder(AbstractTransactionManager transactionManager, PersistenceManager persistenceManager, EntityIdGenerator idGenerator, KeyCreator keyCreator) {
        this.transactionManager = transactionManager;
        this.persistenceManager = persistenceManager;
        this.idGenerator = idGenerator;
        this.keyCreator = keyCreator;
    }

    void addKeyEntries(NameData ... keys) {
        for (NameData key : keys) {
            this.addKeyEntry(key.getName(), key.getId());
        }
    }

    protected void addKeyEntry(String key, int id) {
        KEY keyImpl = this.newKey(key, id);
        this.keyToId.put(key, id);
        this.idToKey.put(id, keyImpl);
    }

    void removeKeyEntry(int id) {
        KEY key = this.idToKey.remove(id);
        this.keyToId.remove(this.nameOf(key));
    }

    public int getOrCreateId(String key) {
        Integer id = this.keyToId.get(key);
        if (id != null) {
            return id;
        }
        id = this.createKey(key);
        return id;
    }

    private synchronized int createKey(String keyName) {
        Integer id = this.keyToId.get(keyName);
        if (id != null) {
            return id;
        }
        id = this.keyCreator.getOrCreate(this.transactionManager, this.idGenerator, this.persistenceManager, keyName);
        this.addKeyEntry(keyName, id);
        return id;
    }

    protected abstract String nameOf(KEY var1);

    public KEY getKeyById(int id) throws KeyNotFoundException {
        KEY result = this.getKeyByIdOrNull(id);
        if (result == null) {
            throw new KeyNotFoundException("Key for id " + id);
        }
        return result;
    }

    public KEY getKeyByIdOrNull(int id) {
        KEY result = this.idToKey.get(id);
        return result;
    }

    public boolean hasKeyById(int id) {
        return this.idToKey.containsKey(id);
    }

    public final int getIdByKey(KEY key) throws KeyNotFoundException {
        return this.getIdByKeyName(this.nameOf(key));
    }

    public int getIdByKeyName(String keyName) throws KeyNotFoundException {
        Integer id = this.keyToId.get(keyName);
        if (id == null) {
            throw new KeyNotFoundException(keyName);
        }
        return id;
    }

    public Iterable<KEY> getAllKeys() {
        return this.idToKey.values();
    }

    @Override
    public void stop() {
        this.keyToId.clear();
        this.idToKey.clear();
    }

    protected abstract KEY newKey(String var1, int var2);
}

