/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cleanup;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.kernel.impl.cleanup.CleanupReference;

class AutoCleanupResourceIterator<T>
implements ResourceIterator<T> {
    private final Iterator<T> iterator;
    CleanupReference cleanup;

    public AutoCleanupResourceIterator(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    @Override
    public void close() {
        try {
            this.cleanup.cleanupNow(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception when closing.", e);
        }
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    @Override
    public T next() {
        try {
            return this.iterator.next();
        }
        catch (NoSuchElementException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public String toString() {
        return String.format("AutoCleanupResourceIterator(%s)", this.iterator);
    }
}

