/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.DiffSets;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.state.LabelState;
import org.neo4j.kernel.impl.api.state.NodeState;
import org.neo4j.kernel.impl.api.state.OldTxStateBridge;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.persistence.PersistenceManager;

public class TxState {
    private final Map<Long, NodeState> nodeStates = new HashMap<Long, NodeState>();
    private final Map<Long, LabelState> labelStates = new HashMap<Long, LabelState>();
    private final DiffSets<IndexRule> ruleDiffSets = new DiffSets();
    private final DiffSets<Long> nodes = new DiffSets();
    private final OldTxStateBridge legacyState;
    private final PersistenceManager persistenceManager;
    private final IdGeneration idGeneration;
    private final SchemaIndexProviderMap providerMap;

    public TxState(OldTxStateBridge legacyState, PersistenceManager legacyTransaction, IdGeneration idGeneration, SchemaIndexProviderMap providerMap) {
        this.legacyState = legacyState;
        this.persistenceManager = legacyTransaction;
        this.idGeneration = idGeneration;
        this.providerMap = providerMap;
    }

    public boolean hasChanges() {
        return !this.nodeStates.isEmpty() || !this.labelStates.isEmpty() || !this.nodes.isEmpty() || this.legacyState.hasChanges();
    }

    public Iterable<NodeState> getNodeStates() {
        return this.nodeStates.values();
    }

    public DiffSets<Long> getLabelStateNodeDiffSets(long labelId) {
        return this.getOrCreateLabelState(labelId).getNodeDiffSets();
    }

    public DiffSets<Long> getNodeStateLabelDiffSets(long nodeId) {
        return this.getOrCreateNodeState(nodeId).getLabelDiffSets();
    }

    public void deleteNode(long nodeId) {
        this.legacyState.deleteNode(nodeId);
        this.nodes.remove(nodeId);
    }

    public boolean nodeIsDeletedInThisTx(long nodeId) {
        return this.nodes.isRemoved(nodeId);
    }

    public boolean nodeIsAddedInThisTx(long nodeId) {
        return this.legacyState.nodeIsAddedInThisTx(nodeId);
    }

    public void addLabelToNode(long labelId, long nodeId) {
        this.getLabelStateNodeDiffSets(labelId).add(nodeId);
        this.getNodeStateLabelDiffSets(nodeId).add(labelId);
        this.persistenceManager.addLabelToNode(labelId, nodeId);
    }

    public void removeLabelFromNode(long labelId, long nodeId) {
        this.getLabelStateNodeDiffSets(labelId).remove(nodeId);
        this.getNodeStateLabelDiffSets(nodeId).remove(labelId);
        this.persistenceManager.removeLabelFromNode(labelId, nodeId);
    }

    public Boolean getLabelState(long nodeId, long labelId) {
        NodeState nodeState = this.getState(this.nodeStates, nodeId, null);
        if (nodeState != null) {
            DiffSets<Long> labelDiff = nodeState.getLabelDiffSets();
            if (labelDiff.isAdded(labelId)) {
                return Boolean.TRUE;
            }
            if (labelDiff.isRemoved(labelId)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public Set<Long> getNodesWithLabelAdded(long labelId) {
        LabelState state = this.getState(this.labelStates, labelId, null);
        return state == null ? Collections.emptySet() : state.getNodeDiffSets().getAdded();
    }

    public DiffSets<Long> getNodesWithLabelChanged(long labelId) {
        LabelState state = this.getState(this.labelStates, labelId, null);
        return state == null ? DiffSets.emptyDiffSets() : state.getNodeDiffSets();
    }

    public IndexRule addIndexRule(long labelId, long propertyKey) {
        SchemaIndexProvider.Descriptor providerDescriptor = this.providerMap.getDefaultProvider().getProviderDescriptor();
        IndexRule rule = new IndexRule(this.idGeneration.newSchemaRuleId(), labelId, providerDescriptor, propertyKey);
        this.persistenceManager.createSchemaRule(rule);
        this.ruleDiffSets.add(rule);
        LabelState labelState = this.getOrCreateLabelState(rule.getLabel());
        labelState.getIndexRuleDiffSets().add(rule);
        return rule;
    }

    public void dropIndexRule(IndexRule rule) {
        this.ruleDiffSets.remove(rule);
        LabelState labelState = this.getOrCreateLabelState(rule.getLabel());
        labelState.getIndexRuleDiffSets().remove(rule);
        this.persistenceManager.dropSchemaRule(rule.getId());
    }

    public DiffSets<IndexRule> getIndexRuleDiffSetsByLabel(long labelId) {
        LabelState labelState = this.getState(this.labelStates, labelId, null);
        return labelState != null ? labelState.getIndexRuleDiffSets() : DiffSets.emptyDiffSets();
    }

    public DiffSets<IndexRule> getIndexRuleDiffSets() {
        return this.ruleDiffSets;
    }

    public DiffSets<Long> getNodesWithChangedProperty(long propertyKeyId, Object value) {
        return this.legacyState.getNodesWithChangedProperty(propertyKeyId, value);
    }

    public DiffSets<Long> getDeletedNodes() {
        return this.nodes;
    }

    public boolean hasSchemaChanges() {
        return !this.getIndexRuleDiffSets().getRemoved().isEmpty();
    }

    private LabelState getOrCreateLabelState(long labelId) {
        return this.getState(this.labelStates, labelId, new StateCreator<LabelState>(){

            @Override
            public LabelState newState(long id) {
                return new LabelState(id);
            }
        });
    }

    private NodeState getOrCreateNodeState(long nodeId) {
        return this.getState(this.nodeStates, nodeId, new StateCreator<NodeState>(){

            @Override
            public NodeState newState(long id) {
                return new NodeState(id);
            }
        });
    }

    private <STATE> STATE getState(Map<Long, STATE> states, long id, StateCreator<STATE> creator) {
        STATE result = states.get(id);
        if (result != null) {
            return result;
        }
        if (creator != null) {
            result = creator.newState(id);
            states.put(id, result);
        }
        return result;
    }

    private static interface StateCreator<STATE> {
        public STATE newState(long var1);
    }

    public static interface IdGeneration {
        public long newSchemaRuleId();
    }
}

