/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.ConstraintViolationKernelException;
import org.neo4j.kernel.api.EntityNotFoundException;
import org.neo4j.kernel.api.LabelNotFoundKernelException;
import org.neo4j.kernel.api.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.PropertyKeyNotFoundException;
import org.neo4j.kernel.api.PropertyNotFoundException;
import org.neo4j.kernel.api.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.impl.api.CompositeStatementContext;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.KeyNotFoundException;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.core.PropertyIndexManager;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;

public class StoreStatementContext
extends CompositeStatementContext {
    private final PropertyIndexManager propertyIndexManager;
    private final NodeManager nodeManager;
    private final NeoStore neoStore;
    private final IndexingService indexService;
    private final IndexReaderFactory indexReaderFactory;
    private final NodeStore nodeStore;
    private final Function<String, Long> propertyStringToId = new Function<String, Long>(){

        @Override
        public Long apply(String s) {
            try {
                return StoreStatementContext.this.getPropertyKeyId(s);
            }
            catch (PropertyKeyNotFoundException e) {
                throw new ThisShouldNotHappenError("Jake", "Property key id stored in store should exist.");
            }
        }
    };

    public StoreStatementContext(PropertyIndexManager propertyIndexManager, NodeManager nodeManager, NeoStore neoStore, IndexingService indexService, IndexReaderFactory indexReaderFactory) {
        assert (neoStore != null) : "No neoStore provided";
        this.indexService = indexService;
        this.indexReaderFactory = indexReaderFactory;
        this.propertyIndexManager = propertyIndexManager;
        this.nodeManager = nodeManager;
        this.neoStore = neoStore;
        this.nodeStore = neoStore.getNodeStore();
    }

    @Override
    protected void beforeWriteOperation() {
        throw new UnsupportedOperationException("The storage layer can not be written to directly, you have to go through a transaction.");
    }

    @Override
    public void close() {
        this.indexReaderFactory.close();
    }

    @Override
    public long getOrCreateLabelId(String label) throws ConstraintViolationKernelException {
        try {
            return this.propertyIndexManager.getOrCreateId(label);
        }
        catch (TransactionFailureException e) {
            if (e.getCause() != null && e.getCause() instanceof UnderlyingStorageException && e.getCause().getMessage().equals("Id capacity exceeded")) {
                throw new ConstraintViolationKernelException("The maximum number of labels available has been reached, cannot create more labels.", e);
            }
            throw e;
        }
    }

    @Override
    public long getLabelId(String label) throws LabelNotFoundKernelException {
        try {
            return this.propertyIndexManager.getIdByKeyName(label);
        }
        catch (KeyNotFoundException e) {
            throw new LabelNotFoundKernelException(label, e);
        }
    }

    @Override
    public boolean isLabelSetOnNode(long labelId, long nodeId) {
        try {
            return IteratorUtil.contains(this.getLabelsForNode(nodeId), labelId);
        }
        catch (InvalidRecordException e) {
            return false;
        }
    }

    @Override
    public Iterator<Long> getLabelsForNode(long nodeId) {
        try {
            return IteratorUtil.asIterator(this.nodeStore.getLabelsForNode(this.nodeStore.getRecord(nodeId)));
        }
        catch (InvalidRecordException e) {
            return IteratorUtil.emptyIterator();
        }
    }

    @Override
    public String getLabelName(long labelId) throws LabelNotFoundKernelException {
        try {
            return ((PropertyIndex)this.propertyIndexManager.getKeyById((int)labelId)).getKey();
        }
        catch (KeyNotFoundException e) {
            throw new LabelNotFoundKernelException("Label by id " + labelId, e);
        }
    }

    @Override
    public Iterator<Long> getNodesWithLabel(final long labelId) {
        final NodeStore nodeStore = this.neoStore.getNodeStore();
        final long highestId = nodeStore.getHighestPossibleIdInUse();
        return new PrefetchingIterator<Long>(){
            private long id = 0L;

            @Override
            protected Long fetchNextOrNull() {
                while (this.id <= highestId) {
                    NodeRecord node;
                    if (!(node = nodeStore.forceGetRecord(this.id++)).inUse()) continue;
                    for (long label : nodeStore.getLabelsForNode(node)) {
                        if (label != labelId) continue;
                        return node.getId();
                    }
                }
                return null;
            }
        };
    }

    @Override
    public IndexRule getIndexRule(final long labelId, final long propertyKey) throws SchemaRuleNotFoundException {
        Iterator<SchemaRule> filtered = Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.INDEX_RULE && propertyKey == ((IndexRule)rule).getPropertyKey();
            }
        }, this.neoStore.getSchemaStore().loadAll());
        if (!filtered.hasNext()) {
            throw new SchemaRuleNotFoundException("Index rule for label:" + labelId + " and property:" + propertyKey + " not found");
        }
        IndexRule rule = (IndexRule)filtered.next();
        if (filtered.hasNext()) {
            throw new SchemaRuleNotFoundException("Found more than one matching index");
        }
        return rule;
    }

    @Override
    public IndexDescriptor getIndexDescriptor(long indexId) throws IndexNotFoundKernelException {
        return this.indexService.getIndexDescriptor(indexId);
    }

    @Override
    public Iterator<IndexRule> getIndexRules(final long labelId) {
        return this.toIndexRules(new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.INDEX_RULE;
            }
        });
    }

    @Override
    public Iterator<IndexRule> getIndexRules() {
        return this.toIndexRules(new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getKind() == SchemaRule.Kind.INDEX_RULE;
            }
        });
    }

    private Iterator<IndexRule> toIndexRules(Predicate<SchemaRule> filter) {
        Iterator<SchemaRule> filtered = Iterables.filter(filter, this.neoStore.getSchemaStore().loadAll());
        return Iterables.map(new Function<SchemaRule, IndexRule>(){

            @Override
            public IndexRule apply(SchemaRule from) {
                return (IndexRule)from;
            }
        }, filtered);
    }

    @Override
    public InternalIndexState getIndexState(IndexRule indexRule) throws IndexNotFoundKernelException {
        return this.indexService.getProxyForRule(indexRule.getId()).getState();
    }

    @Override
    public long getOrCreatePropertyKeyId(String propertyKey) {
        return this.propertyIndexManager.getOrCreateId(propertyKey);
    }

    @Override
    public long getPropertyKeyId(String propertyKey) throws PropertyKeyNotFoundException {
        try {
            return this.propertyIndexManager.getIdByKeyName(propertyKey);
        }
        catch (KeyNotFoundException e) {
            throw new PropertyKeyNotFoundException(propertyKey, e);
        }
    }

    @Override
    public String getPropertyKeyName(long propertyId) throws PropertyKeyIdNotFoundException {
        try {
            return ((PropertyIndex)this.propertyIndexManager.getKeyById((int)propertyId)).getKey();
        }
        catch (KeyNotFoundException e) {
            throw new PropertyKeyIdNotFoundException(propertyId, e);
        }
    }

    @Override
    public Iterator<Long> listNodePropertyKeys(long nodeId) {
        return Iterables.map(this.propertyStringToId, this.nodeManager.getNodeForProxy(nodeId, null).getPropertyKeys(this.nodeManager).iterator());
    }

    @Override
    public Iterator<Long> listRelationshipPropertyKeys(long relId) {
        return Iterables.map(this.propertyStringToId, this.nodeManager.getRelationshipForProxy(relId, null).getPropertyKeys(this.nodeManager).iterator());
    }

    @Override
    public Object getNodePropertyValue(long nodeId, long propertyKeyId) throws PropertyKeyIdNotFoundException, PropertyNotFoundException, EntityNotFoundException {
        try {
            String propertyKey = this.getPropertyKeyName(propertyKeyId);
            return this.nodeManager.getNodeForProxy(nodeId, null).getProperty(this.nodeManager, propertyKey);
        }
        catch (IllegalStateException e) {
            throw new EntityNotFoundException("Unable to load node " + nodeId + ".", e);
        }
        catch (NotFoundException e) {
            throw new PropertyNotFoundException("No property with id " + propertyKeyId + " on node with id " + nodeId, e);
        }
    }

    @Override
    public Iterator<Long> exactIndexLookup(long indexId, Object value) throws IndexNotFoundKernelException {
        return this.indexReaderFactory.newReader(indexId).lookup(value);
    }

    @Override
    public <K, V> V getOrCreateFromSchemaState(K key, Function<K, V> creator) {
        throw new UnsupportedOperationException("Schema state is not handled by the stores");
    }

    @Override
    public <K> boolean schemaStateContains(K key) {
        throw new UnsupportedOperationException("Schema state is not handled by the stores");
    }
}

