/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.TransactionContext;
import org.neo4j.kernel.impl.api.CachingStatementContext;
import org.neo4j.kernel.impl.api.CompositeStatementContext;
import org.neo4j.kernel.impl.api.ConstraintEvaluatingTransactionContext;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.LockingTransactionContext;
import org.neo4j.kernel.impl.api.PersistenceCache;
import org.neo4j.kernel.impl.api.ReadOnlyStatementContext;
import org.neo4j.kernel.impl.api.ReferenceCountingTransactionContext;
import org.neo4j.kernel.impl.api.SchemaCache;
import org.neo4j.kernel.impl.api.SchemaStateOperations;
import org.neo4j.kernel.impl.api.StateHandlingTransactionContext;
import org.neo4j.kernel.impl.api.StatementContextOwner;
import org.neo4j.kernel.impl.api.StoreStatementContext;
import org.neo4j.kernel.impl.api.StoreTransactionContext;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.state.OldTxStateBridgeImpl;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyIndexManager;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.DataSourceRegistrationListener;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Kernel
extends LifecycleAdapter
implements KernelAPI {
    private final AbstractTransactionManager transactionManager;
    private final PropertyIndexManager propertyIndexManager;
    private final PersistenceManager persistenceManager;
    private final XaDataSourceManager dataSourceManager;
    private final LockManager lockManager;
    private final DependencyResolver dependencyResolver;
    private SchemaCache schemaCache;
    private final UpdateableSchemaState schemaState;
    private final StatementContextOwners statementContextOwners = new StatementContextOwners();
    private SchemaIndexProviderMap providerMap = null;
    private IndexingService indexService;
    private NeoStore neoStore;
    private NodeManager nodeManager;
    private PersistenceCache persistenceCache;

    public Kernel(AbstractTransactionManager transactionManager, PropertyIndexManager propertyIndexManager, PersistenceManager persistenceManager, XaDataSourceManager dataSourceManager, LockManager lockManager, UpdateableSchemaState schemaState, DependencyResolver dependencyResolver) {
        this.transactionManager = transactionManager;
        this.propertyIndexManager = propertyIndexManager;
        this.persistenceManager = persistenceManager;
        this.dataSourceManager = dataSourceManager;
        this.lockManager = lockManager;
        this.dependencyResolver = dependencyResolver;
        this.schemaState = schemaState;
    }

    @Override
    public void start() throws Throwable {
        this.nodeManager = this.dependencyResolver.resolveDependency(NodeManager.class);
        this.dataSourceManager.addDataSourceRegistrationListener(new DataSourceRegistrationListener(){

            @Override
            public void registeredDataSource(XaDataSource ds) {
                if (this.isNeoDataSource(ds)) {
                    NeoStoreXaDataSource neoDataSource = (NeoStoreXaDataSource)ds;
                    Kernel.this.neoStore = neoDataSource.getNeoStore();
                    Kernel.this.indexService = neoDataSource.getIndexService();
                    Kernel.this.providerMap = neoDataSource.getProviderMap();
                    Kernel.this.persistenceCache = neoDataSource.getPersistenceCache();
                    Kernel.this.schemaCache = neoDataSource.getSchemaCache();
                    for (SchemaRule schemaRule : IteratorUtil.loop(Kernel.this.neoStore.getSchemaStore().loadAll())) {
                        Kernel.this.schemaCache.addSchemaRule(schemaRule);
                    }
                }
            }

            @Override
            public void unregisteredDataSource(XaDataSource ds) {
                if (this.isNeoDataSource(ds)) {
                    Kernel.this.neoStore = null;
                }
            }

            private boolean isNeoDataSource(XaDataSource ds) {
                return ds.getName().equals("nioneodb");
            }
        });
    }

    @Override
    public void stop() throws Throwable {
        this.statementContextOwners.close();
    }

    @Override
    public TransactionContext newTransactionContext() {
        TransactionContext result = new StoreTransactionContext(this.propertyIndexManager, this.nodeManager, this.neoStore, this.indexService);
        result = new StateHandlingTransactionContext(result, this.newTxState(), this.persistenceCache, this.schemaCache, this.schemaState);
        result = new ConstraintEvaluatingTransactionContext(result);
        result = new LockingTransactionContext(result, this.lockManager, this.transactionManager);
        result = new ReferenceCountingTransactionContext(result);
        return result;
    }

    @Override
    public StatementContext newReadOnlyStatementContext() {
        return ((StatementContextOwner)this.statementContextOwners.get()).getStatementContext();
    }

    private StatementContext createReadOnlyStatementContext() {
        StatementContext result = new StoreStatementContext(this.propertyIndexManager, this.nodeManager, this.neoStore, this.indexService, new IndexReaderFactory.Caching(this.indexService));
        result = new CachingStatementContext(result, this.persistenceCache, this.schemaCache);
        result = new ReadOnlyStatementContext(result);
        result = this.createSchemaStateStatementContext(result);
        return result;
    }

    private StatementContext createSchemaStateStatementContext(StatementContext inner) {
        SchemaStateOperations schemaOps = new SchemaStateOperations(inner, this.schemaState);
        return new CompositeStatementContext(inner, schemaOps);
    }

    private TxState newTxState() {
        return new TxState(new OldTxStateBridgeImpl(this.nodeManager, this.transactionManager.getTransactionState()), this.persistenceManager, new TxState.IdGeneration(){

            @Override
            public long newSchemaRuleId() {
                return Kernel.this.neoStore.getSchemaStore().nextId();
            }
        }, this.providerMap);
    }

    private class StatementContextOwners
    extends ThreadLocal<StatementContextOwner> {
        private final Collection<StatementContextOwner> all = Collections.synchronizedList(new ArrayList());

        private StatementContextOwners() {
        }

        @Override
        protected StatementContextOwner initialValue() {
            StatementContextOwner owner = new StatementContextOwner(){

                @Override
                protected StatementContext createStatementContext() {
                    return Kernel.this.createReadOnlyStatementContext();
                }
            };
            this.all.add(owner);
            return owner;
        }

        void close() {
            for (StatementContextOwner owner : this.all) {
                owner.closeAllStatements();
            }
        }
    }
}

