/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.impl.api.CompositeStatementContext;

public class InteractionStoppingStatementContext
extends CompositeStatementContext {
    private boolean closed;

    public InteractionStoppingStatementContext(StatementContext delegate) {
        super(delegate);
    }

    @Override
    protected void beforeOperation() {
        this.assertOperationsAllowed();
    }

    @Override
    public void close() {
        this.markAsClosed();
        super.close();
    }

    protected void markAsClosed() {
        this.assertOperationsAllowed();
        this.closed = true;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    private void assertOperationsAllowed() {
        if (this.closed) {
            throw new IllegalStateException("This StatementContext has been closed. No more interaction allowed");
        }
    }
}

