/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.api.ConstraintViolationKernelException;
import org.neo4j.kernel.api.EntityNotFoundException;
import org.neo4j.kernel.api.LabelNotFoundKernelException;
import org.neo4j.kernel.api.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.PropertyKeyNotFoundException;
import org.neo4j.kernel.api.PropertyNotFoundException;
import org.neo4j.kernel.api.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.operations.EntityOperations;
import org.neo4j.kernel.api.operations.LabelOperations;
import org.neo4j.kernel.api.operations.PropertyOperations;
import org.neo4j.kernel.api.operations.SchemaOperations;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;

public class CompositeStatementContext
implements StatementContext {
    private final EntityOperations entityOperations;
    private final PropertyOperations propertyOperations;
    private final LabelOperations labelOperations;
    private final SchemaOperations schemaOperations;
    private final StatementContext delegateToClose;

    public CompositeStatementContext() {
        StatementContext unsupportedOpDelegate = (StatementContext)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{StatementContext.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String outerName = CompositeStatementContext.this.getClass().getSimpleName();
                throw new UnsupportedOperationException(String.format("%s does not support %s.", outerName, method.getName()));
            }
        });
        this.entityOperations = unsupportedOpDelegate;
        this.propertyOperations = unsupportedOpDelegate;
        this.labelOperations = unsupportedOpDelegate;
        this.schemaOperations = unsupportedOpDelegate;
        this.delegateToClose = unsupportedOpDelegate;
    }

    public CompositeStatementContext(StatementContext delegate) {
        this.entityOperations = delegate;
        this.propertyOperations = delegate;
        this.labelOperations = delegate;
        this.schemaOperations = delegate;
        this.delegateToClose = delegate;
    }

    public CompositeStatementContext(StatementContext delegate, SchemaOperations schemaOperations) {
        this.entityOperations = delegate;
        this.propertyOperations = delegate;
        this.labelOperations = delegate;
        this.schemaOperations = schemaOperations;
        this.delegateToClose = delegate;
    }

    protected void beforeOperation() {
    }

    protected void afterOperation() {
    }

    protected void beforeReadOperation() {
    }

    protected void afterReadOperation() {
    }

    protected void beforeWriteOperation() {
    }

    protected void afterWriteOperation() {
    }

    @Override
    public void close() {
        if (this.delegateToClose == null) {
            throw new IllegalStateException("Asked to close, but was not given a full implementation of statement context. Please either override this close method, or give CompositeStatementContext a full implementation of the statement context interface.");
        }
        this.delegateToClose.close();
    }

    @Override
    public Iterator<Long> getNodesWithLabel(long labelId) {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<Long> result = this.entityOperations.getNodesWithLabel(labelId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<Long> exactIndexLookup(long indexId, Object value) throws IndexNotFoundKernelException {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<Long> result = this.entityOperations.exactIndexLookup(indexId, value);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public long getLabelId(String label) throws LabelNotFoundKernelException {
        this.beforeOperation();
        this.beforeReadOperation();
        long result = this.labelOperations.getLabelId(label);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public String getLabelName(long labelId) throws LabelNotFoundKernelException {
        this.beforeOperation();
        this.beforeReadOperation();
        String result = this.labelOperations.getLabelName(labelId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public boolean isLabelSetOnNode(long labelId, long nodeId) throws EntityNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        boolean result = this.labelOperations.isLabelSetOnNode(labelId, nodeId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<Long> getLabelsForNode(long nodeId) throws EntityNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<Long> result = this.labelOperations.getLabelsForNode(nodeId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public long getPropertyKeyId(String propertyKey) throws PropertyKeyNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        long result = this.propertyOperations.getPropertyKeyId(propertyKey);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public String getPropertyKeyName(long propertyId) throws PropertyKeyIdNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        String result = this.propertyOperations.getPropertyKeyName(propertyId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Object getNodePropertyValue(long nodeId, long propertyId) throws PropertyKeyIdNotFoundException, PropertyNotFoundException, EntityNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        Object result = this.propertyOperations.getNodePropertyValue(nodeId, propertyId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<Long> listNodePropertyKeys(long nodeId) {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<Long> result = this.propertyOperations.listNodePropertyKeys(nodeId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<Long> listRelationshipPropertyKeys(long relationshipId) {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<Long> result = this.propertyOperations.listRelationshipPropertyKeys(relationshipId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public IndexRule getIndexRule(long labelId, long propertyKey) throws SchemaRuleNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        IndexRule result = this.schemaOperations.getIndexRule(labelId, propertyKey);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public IndexDescriptor getIndexDescriptor(long indexId) throws IndexNotFoundKernelException {
        this.beforeOperation();
        this.beforeReadOperation();
        IndexDescriptor result = this.schemaOperations.getIndexDescriptor(indexId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<IndexRule> getIndexRules(long labelId) {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<IndexRule> result = this.schemaOperations.getIndexRules(labelId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<IndexRule> getIndexRules() {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<IndexRule> result = this.schemaOperations.getIndexRules();
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public InternalIndexState getIndexState(IndexRule indexRule) throws IndexNotFoundKernelException {
        this.beforeOperation();
        this.beforeReadOperation();
        InternalIndexState result = this.schemaOperations.getIndexState(indexRule);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public <K> boolean schemaStateContains(K key) {
        this.beforeOperation();
        this.beforeReadOperation();
        boolean result = this.schemaOperations.schemaStateContains(key);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public long getOrCreateLabelId(String label) throws ConstraintViolationKernelException {
        this.beforeOperation();
        this.beforeWriteOperation();
        long result = this.labelOperations.getOrCreateLabelId(label);
        this.afterWriteOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public boolean addLabelToNode(long labelId, long nodeId) throws EntityNotFoundException {
        this.beforeOperation();
        this.beforeWriteOperation();
        boolean result = this.labelOperations.addLabelToNode(labelId, nodeId);
        this.afterWriteOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public boolean removeLabelFromNode(long labelId, long nodeId) throws EntityNotFoundException {
        this.beforeOperation();
        this.beforeWriteOperation();
        boolean result = this.labelOperations.removeLabelFromNode(labelId, nodeId);
        this.afterWriteOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public long getOrCreatePropertyKeyId(String propertyKey) {
        this.beforeOperation();
        this.beforeWriteOperation();
        long result = this.propertyOperations.getOrCreatePropertyKeyId(propertyKey);
        this.afterWriteOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public IndexRule addIndexRule(long labelId, long propertyKey) throws ConstraintViolationKernelException {
        this.beforeOperation();
        this.beforeWriteOperation();
        IndexRule result = this.schemaOperations.addIndexRule(labelId, propertyKey);
        this.afterWriteOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public void dropIndexRule(IndexRule indexRule) throws ConstraintViolationKernelException {
        this.beforeOperation();
        this.beforeWriteOperation();
        this.schemaOperations.dropIndexRule(indexRule);
        this.afterWriteOperation();
        this.afterOperation();
    }

    @Override
    public <K, V> V getOrCreateFromSchemaState(K key, Function<K, V> creator) {
        this.beforeOperation();
        V result = this.schemaOperations.getOrCreateFromSchemaState(key, creator);
        this.afterOperation();
        return result;
    }

    @Override
    public void deleteNode(long nodeId) {
        this.beforeOperation();
        this.beforeWriteOperation();
        this.entityOperations.deleteNode(nodeId);
        this.afterWriteOperation();
        this.afterOperation();
    }
}

