/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.EntityNotFoundException;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.impl.api.CompositeStatementContext;
import org.neo4j.kernel.impl.api.PersistenceCache;
import org.neo4j.kernel.impl.api.SchemaCache;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;

public class CachingStatementContext
extends CompositeStatementContext {
    private static final Function<? super SchemaRule, IndexRule> TO_INDEX_RULE = new Function<SchemaRule, IndexRule>(){

        @Override
        public IndexRule apply(SchemaRule from) {
            return (IndexRule)from;
        }
    };
    private final PersistenceCache persistenceCache;
    private final SchemaCache schemaCache;
    private final StatementContext delegate;

    public CachingStatementContext(StatementContext actual, PersistenceCache persistenceCache, SchemaCache schemaCache) {
        super(actual);
        this.persistenceCache = persistenceCache;
        this.schemaCache = schemaCache;
        this.delegate = actual;
    }

    @Override
    public boolean isLabelSetOnNode(long labelId, long nodeId) throws EntityNotFoundException {
        Set<Long> labels = this.persistenceCache.getLabels(nodeId);
        if (labels != null) {
            return labels.contains(labelId);
        }
        return this.delegate.isLabelSetOnNode(labelId, nodeId);
    }

    @Override
    public Iterator<Long> getLabelsForNode(long nodeId) throws EntityNotFoundException {
        Set<Long> labels = this.persistenceCache.getLabels(nodeId);
        if (labels != null) {
            return labels.iterator();
        }
        return this.delegate.getLabelsForNode(nodeId);
    }

    @Override
    public Iterator<IndexRule> getIndexRules(long labelId) {
        return this.toIndexRules(this.schemaCache.getSchemaRulesForLabel(labelId));
    }

    @Override
    public Iterator<IndexRule> getIndexRules() {
        return this.toIndexRules(this.schemaCache.getSchemaRules());
    }

    private Iterator<IndexRule> toIndexRules(Iterable<SchemaRule> schemaRules) {
        Iterator<SchemaRule> filteredRules = Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule item) {
                return item.getKind() == SchemaRule.Kind.INDEX_RULE;
            }
        }, schemaRules.iterator());
        return Iterables.map(TO_INDEX_RULE, filteredRules);
    }
}

