/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.IndexDefinitionImpl;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.ConstraintViolationKernelException;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.impl.core.KeyHolder;
import org.neo4j.kernel.impl.core.PropertyIndex;

public class IndexCreatorImpl
implements IndexCreator {
    private final Collection<String> propertyKeys;
    private final Label label;
    private final KeyHolder<PropertyIndex> propertyKeyManager;
    private final ThreadToStatementContextBridge ctxProvider;

    IndexCreatorImpl(ThreadToStatementContextBridge ctxProvider, KeyHolder<PropertyIndex> propertyKeyManager, Label label) {
        this.ctxProvider = ctxProvider;
        this.propertyKeyManager = propertyKeyManager;
        this.label = label;
        this.propertyKeys = new ArrayList<String>();
    }

    private IndexCreatorImpl(ThreadToStatementContextBridge ctxProvider, KeyHolder<PropertyIndex> propertyKeyManager, Label label, Collection<String> propertyKeys) {
        this.ctxProvider = ctxProvider;
        this.propertyKeyManager = propertyKeyManager;
        this.label = label;
        this.propertyKeys = propertyKeys;
    }

    @Override
    public IndexCreator on(String propertyKey) {
        if (!this.propertyKeys.isEmpty()) {
            throw new UnsupportedOperationException("Compound indexes are not yet supported, only one property per index is allowed.");
        }
        return new IndexCreatorImpl(this.ctxProvider, this.propertyKeyManager, this.label, IteratorUtil.addToCollection(Arrays.asList(propertyKey), new ArrayList<String>(this.propertyKeys)));
    }

    @Override
    public IndexDefinition create() throws ConstraintViolationException {
        if (this.propertyKeys.isEmpty()) {
            throw new ConstraintViolationException("An index needs at least one property key to index");
        }
        StatementContext context = this.ctxProvider.getCtxForWriting();
        try {
            String singlePropertyKey = IteratorUtil.single(this.propertyKeys);
            context.addIndexRule(context.getOrCreateLabelId(this.label.name()), this.propertyKeyManager.getOrCreateId(singlePropertyKey));
            IndexDefinitionImpl indexDefinitionImpl = new IndexDefinitionImpl(this.ctxProvider, this.label, singlePropertyKey);
            return indexDefinitionImpl;
        }
        catch (ConstraintViolationKernelException e) {
            throw new ConstraintViolationException(String.format("Unable to create index for label '%s' on properties %s.", this.label.name(), this.propertyKeys), e);
        }
        finally {
            context.close();
        }
    }
}

