/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.kernel.impl.api.PersistenceCache;
import org.neo4j.kernel.impl.api.SchemaCache;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.nioneo.store.NameData;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;

public class BridgingCacheAccess
implements CacheAccessBackDoor {
    private final NodeManager nodeManager;
    private final SchemaCache schemaCache;
    private final SchemaState schemaState;
    private final PersistenceCache persistenceCache;

    public BridgingCacheAccess(NodeManager nodeManager, SchemaCache schemaCache, SchemaState schemaState, PersistenceCache persistenceCache) {
        this.nodeManager = nodeManager;
        this.schemaCache = schemaCache;
        this.schemaState = schemaState;
        this.persistenceCache = persistenceCache;
    }

    @Override
    public void removeNodeFromCache(long nodeId) {
        this.nodeManager.removeNodeFromCache(nodeId);
        this.persistenceCache.evictNode(nodeId);
    }

    @Override
    public void removeRelationshipFromCache(long id) {
        this.nodeManager.removeRelationshipFromCache(id);
    }

    @Override
    public void removeRelationshipTypeFromCache(int id) {
        this.nodeManager.removeRelationshipTypeFromCache(id);
    }

    @Override
    public void removeGraphPropertiesFromCache() {
        this.nodeManager.removeGraphPropertiesFromCache();
    }

    @Override
    public void addSchemaRule(SchemaRule rule) {
        this.schemaCache.addSchemaRule(rule);
    }

    @Override
    public void removeSchemaRuleFromCache(long id) {
        this.schemaCache.removeSchemaRule(id);
        this.schemaState.flush();
    }

    @Override
    public void addRelationshipType(NameData type) {
        this.nodeManager.addRelationshipType(type);
    }

    @Override
    public void addPropertyIndex(NameData index) {
        this.nodeManager.addPropertyIndex(index);
    }

    @Override
    public void patchDeletedRelationshipNodes(long relId, long firstNodeId, long firstNodeNextRelId, long secondNodeId, long secondNodeNextRelId) {
        this.nodeManager.patchDeletedRelationshipNodes(relId, firstNodeId, firstNodeNextRelId, secondNodeId, secondNodeNextRelId);
    }
}

