/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.progress;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.helpers.progress.Aggregator;
import org.neo4j.helpers.progress.Completion;
import org.neo4j.helpers.progress.Indicator;
import org.neo4j.helpers.progress.ProgressListener;

public abstract class ProgressMonitorFactory {
    public static final ProgressMonitorFactory NONE = new ProgressMonitorFactory(){

        @Override
        protected Indicator newIndicator(String process) {
            return Indicator.NONE;
        }
    };

    public static ProgressMonitorFactory textual(OutputStream out) {
        try {
            return ProgressMonitorFactory.textual(new OutputStreamWriter(out, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ProgressMonitorFactory textual(final Writer out) {
        return new ProgressMonitorFactory(){

            @Override
            protected Indicator newIndicator(String process) {
                if (out instanceof PrintWriter) {
                    return new Indicator.Textual(process, (PrintWriter)out);
                }
                return new Indicator.Textual(process, new PrintWriter(out));
            }
        };
    }

    public final MultiPartBuilder multipleParts(String process) {
        return new MultiPartBuilder(this, process);
    }

    public final ProgressListener singlePart(String process, long totalCount) {
        return new ProgressListener.SinglePartProgressListener(this.newIndicator(process), totalCount);
    }

    protected abstract Indicator newIndicator(String var1);

    public static final class MultiPartBuilder {
        private Aggregator aggregator;
        private Set<String> parts = new HashSet<String>();
        private Completion completion = null;

        private MultiPartBuilder(ProgressMonitorFactory factory, String process) {
            this.aggregator = new Aggregator(factory.newIndicator(process));
        }

        public ProgressListener progressForPart(String part, long totalCount) {
            if (this.aggregator == null) {
                throw new IllegalStateException("Builder has been completed.");
            }
            if (!this.parts.add(part)) {
                throw new IllegalArgumentException(String.format("Part '%s' has already been defined.", part));
            }
            ProgressListener.MultiPartProgressListener progress = new ProgressListener.MultiPartProgressListener(this.aggregator, part, totalCount);
            this.aggregator.add(progress);
            return progress;
        }

        public Completion build() {
            if (this.aggregator != null) {
                this.completion = this.aggregator.initialize();
            }
            this.aggregator = null;
            this.parts = null;
            return this.completion;
        }
    }
}

