/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.nioneo.xa.CommandRecordVisitor;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;

public class TransactionReader {
    private static final XaCommandFactory COMMAND_FACTORY = new XaCommandFactory(){

        @Override
        public XaCommand readCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            return Command.readCommand(null, null, byteChannel, buffer);
        }
    };
    private final ByteBuffer buffer = ByteBuffer.wrap(new byte[256]);

    public void read(ReadableByteChannel source, Visitor visitor) throws IOException {
        LogEntry entry;
        while (null != (entry = this.readEntry(source))) {
            LogEntry.Commit commit;
            if (entry instanceof LogEntry.Command) {
                Command command = (Command)((LogEntry.Command)entry).getXaCommand();
                command.accept(new CommandVisitor(entry.getIdentifier(), visitor));
                continue;
            }
            if (entry instanceof LogEntry.Start) {
                LogEntry.Start start = (LogEntry.Start)entry;
                visitor.visitStart(start.getIdentifier(), start.getXid().getGlobalTransactionId(), start.getMasterId(), start.getLocalId(), start.getTimeWritten());
                continue;
            }
            if (entry instanceof LogEntry.Prepare) {
                LogEntry.Prepare prepare = (LogEntry.Prepare)entry;
                visitor.visitPrepare(prepare.getIdentifier(), prepare.getTimeWritten());
                continue;
            }
            if (entry instanceof LogEntry.OnePhaseCommit) {
                commit = (LogEntry.OnePhaseCommit)entry;
                visitor.visitCommit(commit.getIdentifier(), false, commit.getTxId(), commit.getTimeWritten());
                continue;
            }
            if (entry instanceof LogEntry.TwoPhaseCommit) {
                commit = (LogEntry.TwoPhaseCommit)entry;
                visitor.visitCommit(commit.getIdentifier(), true, commit.getTxId(), commit.getTimeWritten());
                continue;
            }
            if (!(entry instanceof LogEntry.Done)) continue;
            LogEntry.Done done = (LogEntry.Done)entry;
            visitor.visitDone(done.getIdentifier());
        }
    }

    private LogEntry readEntry(ReadableByteChannel source) throws IOException {
        return LogIoUtils.readEntry(this.buffer, source, COMMAND_FACTORY);
    }

    private static class CommandVisitor
    implements CommandRecordVisitor {
        private final int localId;
        private final Visitor visitor;

        public CommandVisitor(int localId, Visitor visitor) {
            this.localId = localId;
            this.visitor = visitor;
        }

        @Override
        public void visitNode(NodeRecord record) {
            if (!record.inUse()) {
                this.visitor.visitDeleteNode(this.localId, record.getId());
            } else {
                this.visitor.visitUpdateNode(this.localId, record);
            }
        }

        @Override
        public void visitRelationship(RelationshipRecord record) {
            if (!record.inUse()) {
                this.visitor.visitDeleteRelationship(this.localId, record.getId());
            } else {
                this.visitor.visitUpdateRelationship(this.localId, record);
            }
        }

        @Override
        public void visitProperty(PropertyRecord record) {
            if (!record.inUse()) {
                this.visitor.visitDeleteProperty(this.localId, record.getId());
            } else {
                this.visitor.visitUpdateProperty(this.localId, record);
            }
        }

        @Override
        public void visitRelationshipType(RelationshipTypeRecord record) {
            if (!record.inUse()) {
                this.visitor.visitDeleteRelationshipType(this.localId, record.getId());
            } else {
                this.visitor.visitUpdateRelationshipType(this.localId, record);
            }
        }

        @Override
        public void visitPropertyIndex(PropertyIndexRecord record) {
            if (!record.inUse()) {
                this.visitor.visitDeletePropertyIndex(this.localId, record.getId());
            } else {
                this.visitor.visitUpdatePropertyIndex(this.localId, record);
            }
        }

        @Override
        public void visitNeoStore(NeoStoreRecord record) {
            if (!record.inUse()) {
                this.visitor.visitDeleteNeoStore(this.localId, record.getId());
            } else {
                this.visitor.visitUpdateNeoStore(this.localId, record);
            }
        }
    }

    public static interface Visitor {
        public void visitStart(int var1, byte[] var2, int var3, int var4, long var5);

        public void visitPrepare(int var1, long var2);

        public void visitCommit(int var1, boolean var2, long var3, long var5);

        public void visitDone(int var1);

        public void visitUpdateNode(int var1, NodeRecord var2);

        public void visitDeleteNode(int var1, long var2);

        public void visitUpdateRelationship(int var1, RelationshipRecord var2);

        public void visitDeleteRelationship(int var1, long var2);

        public void visitUpdateProperty(int var1, PropertyRecord var2);

        public void visitDeleteProperty(int var1, long var2);

        public void visitUpdateRelationshipType(int var1, RelationshipTypeRecord var2);

        public void visitDeleteRelationshipType(int var1, int var2);

        public void visitUpdatePropertyIndex(int var1, PropertyIndexRecord var2);

        public void visitDeletePropertyIndex(int var1, int var2);

        public void visitUpdateNeoStore(int var1, NeoStoreRecord var2);

        public void visitDeleteNeoStore(int var1, long var2);
    }
}

