/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.TransactionContext;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.util.MultipleCauseException;
import org.neo4j.kernel.impl.util.StringLogger;

class TransactionImpl
implements Transaction {
    private static final int RS_ENLISTED = 0;
    private static final int RS_SUSPENDED = 1;
    private static final int RS_DELISTED = 2;
    private static final int RS_READONLY = 3;
    private final byte[] globalId;
    private int status = 0;
    private volatile boolean active = true;
    private boolean globalStartRecordWritten = false;
    private final LinkedList<ResourceElement> resourceList = new LinkedList();
    private List<Synchronization> syncHooks = new ArrayList<Synchronization>();
    private boolean hasChanges;
    private final int eventIdentifier;
    private final TxManager txManager;
    private final StringLogger logger;
    private final ForceMode forceMode;
    private Thread owner;
    private final TransactionState state;
    private TransactionContext transactionContext;
    private boolean beforeCompletionRunning = false;
    private List<Synchronization> syncHooksAdded = new ArrayList<Synchronization>();
    private volatile int hashCode = 0;
    private Throwable rollbackCause;

    TransactionImpl(TxManager txManager, ForceMode forceMode, TransactionStateFactory stateFactory, StringLogger logger) {
        this.txManager = txManager;
        this.logger = logger;
        this.state = stateFactory.create(this);
        this.globalId = XidImpl.getNewGlobalId();
        this.eventIdentifier = txManager.getNextEventIdentifier();
        this.forceMode = forceMode;
        this.owner = Thread.currentThread();
    }

    Integer getEventIdentifier() {
        return this.eventIdentifier;
    }

    byte[] getGlobalId() {
        return this.globalId;
    }

    boolean hasChanges() {
        return this.hasChanges;
    }

    public TransactionState getState() {
        return this.state;
    }

    public String toString() {
        return String.format("Transaction(%d, owner:\"%s\")[%s,Resources=%d]", this.eventIdentifier, this.owner.getName(), this.txManager.getTxStatusAsString(this.status), this.resourceList.size());
    }

    public synchronized void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, IllegalStateException, SystemException {
        this.txManager.commit();
        this.transactionContext.commit();
    }

    boolean isGlobalStartRecordWritten() {
        return this.globalStartRecordWritten;
    }

    public synchronized void rollback() throws IllegalStateException, SystemException {
        this.txManager.rollback();
        this.transactionContext.rollback();
    }

    public synchronized boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (xaRes == null) {
            throw new IllegalArgumentException("Null xa resource");
        }
        if (this.status == 0 || this.status == 7) {
            try {
                if (this.resourceList.size() == 0) {
                    if (!this.globalStartRecordWritten) {
                        this.txManager.writeStartRecord(this.globalId);
                        this.globalStartRecordWritten = true;
                    }
                    byte[] branchId = this.txManager.getBranchId(xaRes);
                    XidImpl xid = new XidImpl(this.globalId, branchId);
                    this.resourceList.add(new ResourceElement(xid, xaRes));
                    this.hasChanges = true;
                    xaRes.start(xid, 0);
                    try {
                        this.txManager.getTxLog().addBranch(this.globalId, branchId);
                    }
                    catch (IOException e) {
                        this.logger.error("Error writing transaction log", e);
                        this.txManager.setTmNotOk(e);
                        throw Exceptions.withCause(new SystemException("TM encountered a problem,  error writing transaction log"), e);
                    }
                    if (!this.hasAnyLocks()) {
                        this.getState().getTxHook().initializeTransaction(this.eventIdentifier);
                    }
                    return true;
                }
                Xid sameRmXid = null;
                for (ResourceElement re : this.resourceList) {
                    if (sameRmXid == null && re.getResource().isSameRM(xaRes)) {
                        sameRmXid = re.getXid();
                    }
                    if (xaRes != re.getResource()) continue;
                    if (re.getStatus() == 1) {
                        xaRes.start(re.getXid(), 0x8000000);
                    } else {
                        xaRes.start(re.getXid(), 0x200000);
                    }
                    re.setStatus(0);
                    return true;
                }
                if (sameRmXid != null) {
                    this.addResourceToList(sameRmXid, xaRes);
                    xaRes.start(sameRmXid, 0x200000);
                } else {
                    byte[] branchId = this.txManager.getBranchId(xaRes);
                    XidImpl xid = new XidImpl(this.globalId, branchId);
                    this.addResourceToList(xid, xaRes);
                    xaRes.start(xid, 0);
                    try {
                        this.txManager.getTxLog().addBranch(this.globalId, branchId);
                    }
                    catch (IOException e) {
                        this.logger.error("Error writing transaction log", e);
                        this.txManager.setTmNotOk(e);
                        throw Exceptions.withCause(new SystemException("TM encountered a problem,  error writing transaction log"), e);
                    }
                }
                return true;
            }
            catch (XAException e) {
                this.logger.error("Unable to enlist resource[" + xaRes + "]", e);
                this.status = 1;
                return false;
            }
        }
        if (this.status == 9 || this.status == 4 || this.status == 1) {
            throw new RollbackException("Tx status is: " + this.txManager.getTxStatusAsString(this.status));
        }
        throw new IllegalStateException("Tx status is: " + this.txManager.getTxStatusAsString(this.status));
    }

    private void addResourceToList(Xid xid, XAResource xaRes) {
        ResourceElement element = new ResourceElement(xid, xaRes);
        if (Arrays.equals(NeoStoreXaDataSource.BRANCH_ID, xid.getBranchQualifier())) {
            this.resourceList.addFirst(element);
        } else {
            this.resourceList.add(element);
        }
        this.hasChanges = true;
    }

    public synchronized boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException {
        if (xaRes == null) {
            throw new IllegalArgumentException("Null xa resource");
        }
        if (flag != 0x4000000 && flag != 0x2000000 && flag != 0x20000000) {
            throw new IllegalArgumentException("Illegal flag: " + flag);
        }
        ResourceElement re = null;
        for (ResourceElement reMatch : this.resourceList) {
            if (reMatch.getResource() != xaRes) continue;
            re = reMatch;
            break;
        }
        if (re == null) {
            return false;
        }
        if (this.status == 0 || this.status == 1) {
            try {
                xaRes.end(re.getXid(), flag);
                if (flag == 0x2000000 || flag == 0x20000000) {
                    re.setStatus(1);
                } else {
                    re.setStatus(2);
                }
                return true;
            }
            catch (XAException e) {
                this.logger.error("Unable to delist resource[" + xaRes + "]", e);
                this.status = 1;
                return false;
            }
        }
        throw new IllegalStateException("Tx status is: " + this.txManager.getTxStatusAsString(this.status));
    }

    public int getStatus() {
        return this.status;
    }

    void setStatus(int status) {
        this.status = status;
    }

    public synchronized void registerSynchronization(Synchronization s) throws RollbackException, IllegalStateException {
        if (s == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        if (this.status == 0 || this.status == 7 || this.status == 1) {
            if (!this.beforeCompletionRunning) {
                this.syncHooks.add(s);
            } else {
                this.syncHooksAdded.add(s);
            }
        } else {
            if (this.status == 9 || this.status == 4) {
                throw new RollbackException("Tx status is: " + this.txManager.getTxStatusAsString(this.status));
            }
            throw new IllegalStateException("Tx status is: " + this.txManager.getTxStatusAsString(this.status));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doBeforeCompletion() {
        this.beforeCompletionRunning = true;
        try {
            for (Synchronization s : this.syncHooks) {
                try {
                    s.beforeCompletion();
                }
                catch (Throwable t) {
                    this.addRollbackCause(t);
                }
            }
            while (!this.syncHooksAdded.isEmpty()) {
                List<Synchronization> addedHooks = this.syncHooksAdded;
                this.syncHooksAdded = new ArrayList<Synchronization>();
                for (Synchronization s : addedHooks) {
                    s.beforeCompletion();
                    this.syncHooks.add(s);
                }
            }
        }
        finally {
            this.beforeCompletionRunning = false;
        }
    }

    synchronized void doAfterCompletion() {
        for (Synchronization s : this.syncHooks) {
            try {
                s.afterCompletion(this.status);
            }
            catch (Throwable t) {
                this.logger.warn("Caught exception from tx syncronization[" + s + "] afterCompletion()", t);
            }
        }
        this.syncHooks = null;
    }

    public void setRollbackOnly() throws IllegalStateException {
        if (this.status != 0 && this.status != 7 && this.status != 2 && this.status != 1 && this.status != 9) {
            throw new IllegalStateException("Tx status is: " + this.txManager.getTxStatusAsString(this.status));
        }
        this.status = 1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TransactionImpl)) {
            return false;
        }
        TransactionImpl other = (TransactionImpl)o;
        return this.eventIdentifier == other.eventIdentifier;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 3217 * this.eventIdentifier;
        }
        return this.hashCode;
    }

    int getResourceCount() {
        return this.resourceList.size();
    }

    private boolean isOnePhase() {
        if (this.resourceList.size() == 0) {
            this.logger.warn("Detected zero resources in resourceList");
            return true;
        }
        Iterator itr = this.resourceList.iterator();
        Xid xid = ((ResourceElement)itr.next()).getXid();
        while (itr.hasNext()) {
            if (xid.equals(((ResourceElement)itr.next()).getXid())) continue;
            return false;
        }
        return true;
    }

    void doCommit() throws XAException, SystemException {
        boolean onePhase = this.isOnePhase();
        boolean readOnly = true;
        if (!onePhase) {
            this.status = 7;
            LinkedList<Xid> preparedXids = new LinkedList<Xid>();
            for (ResourceElement re : this.resourceList) {
                if (!preparedXids.contains(re.getXid())) {
                    preparedXids.add(re.getXid());
                    int vote = re.getResource().prepare(re.getXid());
                    if (vote == 0) {
                        readOnly = false;
                        continue;
                    }
                    if (vote == 3) {
                        re.setStatus(3);
                        continue;
                    }
                    this.status = 1;
                    return;
                }
                re.setStatus(3);
            }
            this.status = 2;
        }
        if (!onePhase && readOnly) {
            this.status = 3;
            return;
        }
        if (!onePhase) {
            try {
                this.txManager.getTxLog().markAsCommitting(this.getGlobalId(), this.forceMode);
            }
            catch (IOException e) {
                this.logger.error("Error writing transaction log", e);
                this.txManager.setTmNotOk(e);
                throw Exceptions.withCause(new SystemException("TM encountered a problem,  error writing transaction log"), e);
            }
        }
        this.status = 8;
        for (ResourceElement re : this.resourceList) {
            if (re.getStatus() == 3) continue;
            try {
                re.getResource().commit(re.getXid(), onePhase);
            }
            catch (XAException e) {
                throw e;
            }
            catch (Throwable e) {
                throw Exceptions.withCause(new XAException(-3), e);
            }
        }
        this.status = 3;
    }

    void doRollback() throws XAException {
        this.status = 9;
        LinkedList<Xid> rolledbackXids = new LinkedList<Xid>();
        for (ResourceElement re : this.resourceList) {
            if (rolledbackXids.contains(re.getXid())) continue;
            rolledbackXids.add(re.getXid());
            re.getResource().rollback(re.getXid());
        }
        this.status = 4;
    }

    public StatementContext newStatementContext() {
        return this.transactionContext.newStatementContext();
    }

    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    boolean isActive() {
        return this.active;
    }

    synchronized void markAsActive() {
        if (this.active) {
            throw new IllegalStateException("Transaction[" + this + "] already active");
        }
        this.owner = Thread.currentThread();
        this.active = true;
    }

    synchronized void markAsSuspended() {
        if (!this.active) {
            throw new IllegalStateException("Transaction[" + this + "] already suspended");
        }
        this.active = false;
    }

    public ForceMode getForceMode() {
        return this.forceMode;
    }

    public Throwable getRollbackCause() {
        return this.rollbackCause;
    }

    private void addRollbackCause(Throwable cause) {
        if (this.rollbackCause == null) {
            this.rollbackCause = cause;
        } else {
            if (!(this.rollbackCause instanceof MultipleCauseException)) {
                this.rollbackCause = new MultipleCauseException("Multiple exceptions occurred, stack traces of all of them available below, or via #getCauses().", this.rollbackCause);
            }
            ((MultipleCauseException)this.rollbackCause).addCause(cause);
        }
    }

    public boolean hasAnyLocks() {
        return this.getState().getTxHook().hasAnyLocks(this);
    }

    public void finish(boolean successful) {
        this.getState().getTxHook().finishTransaction(this.getEventIdentifier(), successful);
    }

    private static class ResourceElement {
        private Xid xid = null;
        private XAResource resource = null;
        private int status;

        ResourceElement(Xid xid, XAResource resource) {
            this.xid = xid;
            this.resource = resource;
            this.status = 0;
        }

        Xid getXid() {
            return this.xid;
        }

        XAResource getResource() {
            return this.resource;
        }

        int getStatus() {
            return this.status;
        }

        void setStatus(int status) {
            this.status = status;
        }

        public String toString() {
            String statusString = null;
            switch (this.status) {
                case 0: {
                    statusString = "ENLISTED";
                    break;
                }
                case 2: {
                    statusString = "DELISTED";
                    break;
                }
                case 1: {
                    statusString = "SUSPENDED";
                    break;
                }
                case 3: {
                    statusString = "READONLY";
                    break;
                }
                default: {
                    statusString = "UNKNOWN";
                }
            }
            return "Xid[" + this.xid + "] XAResource[" + this.resource + "] Status[" + statusString + "]";
        }
    }
}

