/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.persistence;

import java.util.Iterator;
import java.util.Map;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.core.TransactionEventsSyncHook;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.core.TxEventSyncHookFactory;
import org.neo4j.kernel.impl.nioneo.store.NameData;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.xa.NioNeoDbPersistenceSource;
import org.neo4j.kernel.impl.persistence.NeoStoreTransaction;
import org.neo4j.kernel.impl.persistence.PersistenceSource;
import org.neo4j.kernel.impl.persistence.ResourceAcquisitionFailedException;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.StringLogger;

public class PersistenceManager {
    private final PersistenceSource persistenceSource;
    private final StringLogger msgLog;
    private final AbstractTransactionManager transactionManager;
    private final ArrayMap<Transaction, NeoStoreTransaction> txConnectionMap = new ArrayMap(5, true, true);
    private final TxEventSyncHookFactory syncHookFactory;

    public PersistenceManager(StringLogger msgLog, AbstractTransactionManager transactionManager, PersistenceSource persistenceSource, TxEventSyncHookFactory syncHookFactory) {
        this.msgLog = msgLog;
        this.transactionManager = transactionManager;
        this.persistenceSource = persistenceSource;
        this.syncHookFactory = syncHookFactory;
    }

    public NodeRecord loadLightNode(long id) {
        return this.getReadOnlyResourceIfPossible().nodeLoadLight(id);
    }

    public Object loadPropertyValue(PropertyData property) {
        return this.getReadOnlyResource().loadPropertyValue(property);
    }

    public NameData[] loadPropertyIndexes() {
        return this.getReadOnlyResource().loadPropertyIndexes();
    }

    public long getRelationshipChainPosition(long nodeId) {
        return this.getReadOnlyResourceIfPossible().getRelationshipChainPosition(nodeId);
    }

    public Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, Long> getMoreRelationships(long nodeId, long position) {
        return this.getReadOnlyResource().getMoreRelationships(nodeId, position);
    }

    public ArrayMap<Integer, PropertyData> loadNodeProperties(long nodeId, boolean light) {
        return this.getReadOnlyResourceIfPossible().nodeLoadProperties(nodeId, light);
    }

    public ArrayMap<Integer, PropertyData> loadRelProperties(long relId, boolean light) {
        return this.getReadOnlyResourceIfPossible().relLoadProperties(relId, light);
    }

    public RelationshipRecord loadLightRelationship(long id) {
        return this.getReadOnlyResourceIfPossible().relLoadLight(id);
    }

    public NameData[] loadAllRelationshipTypes() {
        return this.getReadOnlyResource().loadRelationshipTypes();
    }

    public ArrayMap<Integer, PropertyData> nodeDelete(long nodeId) {
        return this.getResource(true).nodeDelete(nodeId);
    }

    public PropertyData nodeAddProperty(long nodeId, PropertyIndex index, Object value) {
        return this.getResource(true).nodeAddProperty(nodeId, index, value);
    }

    public PropertyData nodeChangeProperty(long nodeId, PropertyData data, Object value) {
        return this.getResource(true).nodeChangeProperty(nodeId, data, value);
    }

    public void nodeRemoveProperty(long nodeId, PropertyData data) {
        this.getResource(true).nodeRemoveProperty(nodeId, data);
    }

    public void nodeCreate(long id) {
        this.getResource(true).nodeCreate(id);
    }

    public void relationshipCreate(long id, int typeId, long startNodeId, long endNodeId) {
        this.getResource(true).relationshipCreate(id, typeId, startNodeId, endNodeId);
    }

    public ArrayMap<Integer, PropertyData> relDelete(long relId) {
        return this.getResource(true).relDelete(relId);
    }

    public PropertyData relAddProperty(long relId, PropertyIndex index, Object value) {
        return this.getResource(true).relAddProperty(relId, index, value);
    }

    public PropertyData relChangeProperty(long relId, PropertyData data, Object value) {
        return this.getResource(true).relChangeProperty(relId, data, value);
    }

    public void relRemoveProperty(long relId, PropertyData data) {
        this.getResource(true).relRemoveProperty(relId, data);
    }

    public PropertyData graphAddProperty(PropertyIndex index, Object value) {
        return this.getResource(true).graphAddProperty(index, value);
    }

    public PropertyData graphChangeProperty(PropertyData data, Object value) {
        return this.getResource(true).graphChangeProperty(data, value);
    }

    public void graphRemoveProperty(PropertyData data) {
        this.getResource(true).graphRemoveProperty(data);
    }

    public ArrayMap<Integer, PropertyData> graphLoadProperties(boolean light) {
        return this.getReadOnlyResourceIfPossible().graphLoadProperties(light);
    }

    public void createPropertyIndex(String key, int id) {
        this.getResource(true).createPropertyIndex(key, id);
    }

    public void createRelationshipType(int id, String name) {
        this.getResource(false).createRelationshipType(id, name);
    }

    private NeoStoreTransaction getReadOnlyResource() {
        return ((NioNeoDbPersistenceSource)this.persistenceSource).createReadOnlyResourceConnection();
    }

    private NeoStoreTransaction getReadOnlyResourceIfPossible() {
        Transaction tx = this.getCurrentTransaction();
        NeoStoreTransaction con = this.txConnectionMap.get(tx);
        if (con == null) {
            return this.getReadOnlyResource();
        }
        return con;
    }

    private NeoStoreTransaction getResource(boolean registerEventHooks) {
        Transaction tx = this.getCurrentTransaction();
        if (tx == null) {
            throw new NotInTransactionException();
        }
        NeoStoreTransaction con = this.txConnectionMap.get(tx);
        if (con == null) {
            try {
                XaConnection xaConnection = this.persistenceSource.getXaDataSource().getXaConnection();
                XAResource xaResource = xaConnection.getXaResource();
                if (!tx.enlistResource(xaResource)) {
                    throw new ResourceAcquisitionFailedException("Unable to enlist '" + xaResource + "' in " + "transaction");
                }
                con = this.persistenceSource.createTransaction(xaConnection);
                TransactionState state = this.transactionManager.getTransactionState();
                tx.registerSynchronization((Synchronization)new TxCommitHook(tx, state));
                if (registerEventHooks) {
                    this.registerTransactionEventHookIfNeeded(tx);
                }
                this.txConnectionMap.put(tx, con);
            }
            catch (RollbackException re) {
                String msg = "The transaction is marked for rollback only.";
                throw new ResourceAcquisitionFailedException(msg, re);
            }
            catch (SystemException se) {
                String msg = "TM encountered an unexpected error condition.";
                throw new ResourceAcquisitionFailedException(msg, se);
            }
        }
        return con;
    }

    private void registerTransactionEventHookIfNeeded(Transaction tx) throws SystemException, RollbackException {
        TransactionEventsSyncHook hook = this.syncHookFactory.create();
        if (hook != null) {
            tx.registerSynchronization((Synchronization)hook);
        }
    }

    private Transaction getCurrentTransaction() throws NotInTransactionException {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException se) {
            throw new TransactionFailureException("Error fetching transaction for current thread", se);
        }
    }

    public void dropSchemaRule(long ruleId) {
        this.getResource(true).dropSchemaRule(ruleId);
    }

    void delistResourcesForTransaction() throws NotInTransactionException {
        Transaction tx = this.getCurrentTransaction();
        if (tx == null) {
            throw new NotInTransactionException();
        }
        NeoStoreTransaction con = this.txConnectionMap.get(tx);
        if (con != null) {
            try {
                con.delistResource(tx, 0x4000000);
            }
            catch (SystemException e) {
                throw new TransactionFailureException("Failed to delist resource '" + con + "' from current transaction.", e);
            }
        }
    }

    void releaseResourceConnectionsForTransaction(Transaction tx) throws NotInTransactionException {
        NeoStoreTransaction con = this.txConnectionMap.remove(tx);
        if (con != null) {
            con.destroy();
        }
    }

    public void createSchemaRule(SchemaRule rule) {
        this.getResource(true).createSchemaRule(rule);
    }

    public void addLabelToNode(long labelId, long nodeId) {
        this.getResource(true).addLabelToNode(labelId, nodeId);
    }

    public void removeLabelFromNode(long labelId, long nodeId) {
        this.getResource(true).removeLabelFromNode(labelId, nodeId);
    }

    public Iterator<Long> getLabelsForNode(long nodeId) {
        return this.getReadOnlyResourceIfPossible().getLabelsForNode(nodeId);
    }

    private class TxCommitHook
    implements Synchronization {
        private final Transaction tx;
        private final TransactionState state;

        TxCommitHook(Transaction tx, TransactionState state) {
            this.tx = tx;
            this.state = state;
        }

        public void afterCompletion(int param) {
            this.releaseConnections(this.tx);
            if (param == 3) {
                this.state.commit();
            } else {
                this.state.rollback();
            }
        }

        public void beforeCompletion() {
            PersistenceManager.this.delistResourcesForTransaction();
        }

        private void releaseConnections(Transaction tx) {
            try {
                PersistenceManager.this.releaseResourceConnectionsForTransaction(tx);
            }
            catch (Throwable t) {
                PersistenceManager.this.msgLog.error("Error releasing resources for " + tx, t);
            }
        }
    }
}

