/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NameData;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaStore;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.nioneo.xa.NodeLabelRecordLogic;
import org.neo4j.kernel.impl.nioneo.xa.ReadTransaction;
import org.neo4j.kernel.impl.nioneo.xa.RecordChanges;
import org.neo4j.kernel.impl.persistence.NeoStoreTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;

public class WriteTransaction
extends XaTransaction
implements NeoStoreTransaction {
    private final RecordChanges<Long, NodeRecord, Void> nodeRecords = new RecordChanges<Long, NodeRecord, Void>(new RecordChanges.Loader<Long, NodeRecord, Void>(){

        @Override
        public NodeRecord newUnused(Long key, Void additionalData) {
            return new NodeRecord(key, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
        }

        @Override
        public NodeRecord load(Long key, Void additionalData) {
            return WriteTransaction.this.getNodeStore().getRecord(key);
        }

        @Override
        public void ensureHeavy(NodeRecord record) {
            WriteTransaction.this.getNodeStore().ensureHeavy(record);
        }
    }, true);
    private final RecordChanges<Long, PropertyRecord, PrimitiveRecord> propertyRecords = new RecordChanges<Long, PropertyRecord, PrimitiveRecord>(new RecordChanges.Loader<Long, PropertyRecord, PrimitiveRecord>(){

        @Override
        public PropertyRecord newUnused(Long key, PrimitiveRecord additionalData) {
            PropertyRecord record = new PropertyRecord(key);
            this.setOwner(record, additionalData);
            return record;
        }

        private void setOwner(PropertyRecord record, PrimitiveRecord owner) {
            if (owner != null) {
                owner.setIdTo(record);
            }
        }

        @Override
        public PropertyRecord load(Long key, PrimitiveRecord additionalData) {
            PropertyRecord record = WriteTransaction.this.getPropertyStore().getRecord(key);
            this.setOwner(record, additionalData);
            return record;
        }

        @Override
        public void ensureHeavy(PropertyRecord record) {
            for (PropertyBlock block : record.getPropertyBlocks()) {
                WriteTransaction.this.getPropertyStore().ensureHeavy(block);
            }
        }
    }, true);
    private final RecordChanges<Long, RelationshipRecord, Void> relRecords = new RecordChanges<Long, RelationshipRecord, Void>(new RecordChanges.Loader<Long, RelationshipRecord, Void>(){

        @Override
        public RelationshipRecord newUnused(Long key, Void additionalData) {
            return new RelationshipRecord(key);
        }

        @Override
        public RelationshipRecord load(Long key, Void additionalData) {
            return WriteTransaction.this.getRelationshipStore().getRecord(key);
        }

        @Override
        public void ensureHeavy(RelationshipRecord record) {
        }
    }, false);
    private final Map<Long, Pair<Collection<DynamicRecord>, SchemaRule>> schemaRuleRecords = new HashMap<Long, Pair<Collection<DynamicRecord>, SchemaRule>>();
    private Map<Integer, RelationshipTypeRecord> relTypeRecords;
    private Map<Integer, PropertyIndexRecord> propIndexRecords;
    private RecordChanges<Long, NeoStoreRecord, Void> neoStoreRecord;
    private final Map<Long, Command.NodeCommand> nodeCommands = new TreeMap<Long, Command.NodeCommand>();
    private final ArrayList<Command.PropertyCommand> propCommands = new ArrayList();
    private final ArrayList<Command.RelationshipCommand> relCommands = new ArrayList();
    private final ArrayList<Command.SchemaRuleCommand> schemaRuleCommands = new ArrayList();
    private ArrayList<Command.RelationshipTypeCommand> relTypeCommands;
    private ArrayList<Command.PropertyIndexCommand> propIndexCommands;
    private Command.NeoStoreCommand neoStoreCommand;
    private final NeoStore neoStore;
    private boolean committed = false;
    private boolean prepared = false;
    private final TransactionState state;
    private XaConnection xaConnection;
    private final CacheAccessBackDoor cacheAccess;
    private final IndexingService indexes;

    WriteTransaction(int identifier, XaLogicalLog log, TransactionState state, NeoStore neoStore, CacheAccessBackDoor cacheAccess, IndexingService indexingService) {
        super(identifier, log, state);
        this.neoStore = neoStore;
        this.state = state;
        this.cacheAccess = cacheAccess;
        this.indexes = indexingService;
    }

    @Override
    public boolean isReadOnly() {
        if (this.isRecovered()) {
            return this.nodeCommands.size() == 0 && this.propCommands.size() == 0 && this.relCommands.size() == 0 && this.schemaRuleCommands.size() == 0 && this.relTypeCommands == null && this.propIndexCommands == null;
        }
        return this.nodeRecords.changeSize() == 0 && this.relRecords.changeSize() == 0 && this.schemaRuleRecords.size() == 0 && this.propertyRecords.changeSize() == 0 && this.relTypeRecords == null && this.propIndexRecords == null;
    }

    @Override
    protected void setRecovered() {
        super.setRecovered();
    }

    @Override
    public void doAddCommand(XaCommand command) {
    }

    @Override
    protected void doPrepare() throws XAException {
        Command command;
        int noOfCommands = this.nodeRecords.changeSize() + this.relRecords.changeSize() + this.propertyRecords.changeSize() + this.schemaRuleRecords.size() + (this.propIndexRecords != null ? this.propIndexRecords.size() : 0) + (this.relTypeRecords != null ? this.relTypeRecords.size() : 0);
        ArrayList<Command> commands = new ArrayList<Command>(noOfCommands);
        if (this.committed) {
            throw new XAException("Cannot prepare committed transaction[" + this.getIdentifier() + "]");
        }
        if (this.prepared) {
            throw new XAException("Cannot prepare prepared transaction[" + this.getIdentifier() + "]");
        }
        this.prepared = true;
        if (this.relTypeRecords != null) {
            this.relTypeCommands = new ArrayList();
            for (RelationshipTypeRecord relationshipTypeRecord : this.relTypeRecords.values()) {
                command = new Command.RelationshipTypeCommand(this.neoStore.getRelationshipTypeStore(), relationshipTypeRecord);
                this.relTypeCommands.add((Command.RelationshipTypeCommand)command);
                commands.add(command);
            }
        }
        for (RecordChanges.RecordChange<Long, NodeRecord, Void> recordChange : this.nodeRecords.changes()) {
            NodeRecord record = recordChange.forReadingLinkage();
            if (!record.inUse() && record.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                throw Exceptions.withCause(new XAException(103), new ConstraintViolationException("Node record " + record + " still has relationships"));
            }
            Command.NodeCommand command2 = new Command.NodeCommand(this.neoStore.getNodeStore(), recordChange.getBefore(), record);
            this.nodeCommands.put(record.getId(), command2);
            commands.add(command2);
        }
        for (RecordChanges.RecordChange recordChange : this.relRecords.changes()) {
            command = new Command.RelationshipCommand(this.neoStore.getRelationshipStore(), (RelationshipRecord)recordChange.forReadingLinkage());
            this.relCommands.add((Command.RelationshipCommand)command);
            commands.add(command);
        }
        if (this.neoStoreRecord != null) {
            for (RecordChanges.RecordChange recordChange : this.neoStoreRecord.changes()) {
                this.neoStoreCommand = new Command.NeoStoreCommand(this.neoStore, (NeoStoreRecord)recordChange.forReadingData());
                this.addCommand(this.neoStoreCommand);
            }
        }
        if (this.propIndexRecords != null) {
            this.propIndexCommands = new ArrayList();
            for (PropertyIndexRecord propertyIndexRecord : this.propIndexRecords.values()) {
                command = new Command.PropertyIndexCommand(this.neoStore.getPropertyStore().getIndexStore(), propertyIndexRecord);
                this.propIndexCommands.add((Command.PropertyIndexCommand)command);
                commands.add(command);
            }
        }
        for (RecordChanges.RecordChange recordChange : this.propertyRecords.changes()) {
            command = new Command.PropertyCommand(this.neoStore.getPropertyStore(), (PropertyRecord)recordChange.getBefore(), (PropertyRecord)recordChange.forReadingLinkage());
            this.propCommands.add((Command.PropertyCommand)command);
            commands.add(command);
        }
        for (Pair pair : this.schemaRuleRecords.values()) {
            command = new Command.SchemaRuleCommand(this.neoStore, this.neoStore.getSchemaStore(), this.indexes, (Collection)pair.first(), (SchemaRule)pair.other());
            this.schemaRuleCommands.add((Command.SchemaRuleCommand)command);
            commands.add(command);
        }
        assert (commands.size() == noOfCommands) : "Expected " + noOfCommands + " final commands, got " + commands.size() + " instead";
        this.intercept(commands);
        for (Command command2 : commands) {
            this.addCommand(command2);
        }
    }

    protected void intercept(List<Command> commands) {
    }

    @Override
    protected void injectCommand(XaCommand xaCommand) {
        if (xaCommand instanceof Command.NodeCommand) {
            Command.NodeCommand nodeCommand = (Command.NodeCommand)xaCommand;
            this.nodeCommands.put(nodeCommand.getKey(), nodeCommand);
        } else if (xaCommand instanceof Command.RelationshipCommand) {
            this.relCommands.add((Command.RelationshipCommand)xaCommand);
        } else if (xaCommand instanceof Command.PropertyCommand) {
            this.propCommands.add((Command.PropertyCommand)xaCommand);
        } else if (xaCommand instanceof Command.PropertyIndexCommand) {
            if (this.propIndexCommands == null) {
                this.propIndexCommands = new ArrayList();
            }
            this.propIndexCommands.add((Command.PropertyIndexCommand)xaCommand);
        } else if (xaCommand instanceof Command.RelationshipTypeCommand) {
            if (this.relTypeCommands == null) {
                this.relTypeCommands = new ArrayList();
            }
            this.relTypeCommands.add((Command.RelationshipTypeCommand)xaCommand);
        } else if (xaCommand instanceof Command.NeoStoreCommand) {
            assert (this.neoStoreCommand == null);
            this.neoStoreCommand = (Command.NeoStoreCommand)xaCommand;
        } else if (xaCommand instanceof Command.SchemaRuleCommand) {
            this.schemaRuleCommands.add((Command.SchemaRuleCommand)xaCommand);
        } else {
            throw new IllegalArgumentException("Unknown command " + xaCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRollback() throws XAException {
        if (this.committed) {
            throw new XAException("Cannot rollback partialy commited transaction[" + this.getIdentifier() + "]. Recover and " + "commit");
        }
        try {
            boolean freeIds = this.neoStore.freeIdsDuringRollback();
            if (this.relTypeRecords != null) {
                for (RelationshipTypeRecord relationshipTypeRecord : this.relTypeRecords.values()) {
                    if (relationshipTypeRecord.isCreated()) {
                        if (freeIds) {
                            this.getRelationshipTypeStore().freeId(relationshipTypeRecord.getId());
                        }
                        for (DynamicRecord dynamicRecord : relationshipTypeRecord.getNameRecords()) {
                            if (!dynamicRecord.isCreated()) continue;
                            this.getRelationshipTypeStore().freeId((int)dynamicRecord.getId());
                        }
                    }
                    this.removeRelationshipTypeFromCache(relationshipTypeRecord.getId());
                }
            }
            for (RecordChanges.RecordChange recordChange : this.nodeRecords.changes()) {
                NodeRecord record = (NodeRecord)recordChange.forReadingLinkage();
                if (freeIds && record.isCreated()) {
                    this.getNodeStore().freeId(record.getId());
                }
                this.removeNodeFromCache(record.getId());
            }
            for (RecordChanges.RecordChange recordChange : this.relRecords.changes()) {
                long id = (Long)recordChange.getKey();
                RelationshipRecord record = (RelationshipRecord)recordChange.forReadingLinkage();
                if (freeIds && recordChange.isCreated()) {
                    this.getRelationshipStore().freeId(id);
                }
                this.removeRelationshipFromCache(id);
                this.patchDeletedRelationshipNodes(id, record.getFirstNode(), record.getFirstNextRel(), record.getSecondNode(), record.getSecondNextRel());
            }
            if (this.neoStoreRecord != null) {
                this.removeGraphPropertiesFromCache();
            }
            if (this.propIndexRecords != null) {
                for (PropertyIndexRecord propertyIndexRecord : this.propIndexRecords.values()) {
                    if (!propertyIndexRecord.isCreated()) continue;
                    if (freeIds) {
                        this.getPropertyStore().getIndexStore().freeId(propertyIndexRecord.getId());
                    }
                    for (DynamicRecord dynamicRecord : propertyIndexRecord.getNameRecords()) {
                        if (!dynamicRecord.isCreated()) continue;
                        this.getPropertyStore().getIndexStore().freeId((int)dynamicRecord.getId());
                    }
                }
            }
            for (RecordChanges.RecordChange recordChange : this.propertyRecords.changes()) {
                PropertyRecord record = (PropertyRecord)recordChange.forReadingLinkage();
                if (record.getNodeId() != -1L) {
                    this.removeNodeFromCache(record.getNodeId());
                } else if (record.getRelId() != -1L) {
                    this.removeRelationshipFromCache(record.getRelId());
                }
                if (!record.isCreated()) continue;
                if (freeIds) {
                    this.getPropertyStore().freeId(record.getId());
                }
                for (PropertyBlock block : record.getPropertyBlocks()) {
                    for (DynamicRecord dynamicRecord : block.getValueRecords()) {
                        if (!dynamicRecord.isCreated()) continue;
                        if (dynamicRecord.getType() == PropertyType.STRING.intValue()) {
                            this.getPropertyStore().freeStringBlockId(dynamicRecord.getId());
                            continue;
                        }
                        if (dynamicRecord.getType() == PropertyType.ARRAY.intValue()) {
                            this.getPropertyStore().freeArrayBlockId(dynamicRecord.getId());
                            continue;
                        }
                        throw new InvalidRecordException("Unknown type on " + dynamicRecord);
                    }
                }
            }
            for (Pair pair : this.schemaRuleRecords.values()) {
                long id = -1L;
                for (DynamicRecord record : (Collection)pair.first()) {
                    if (id == -1L) {
                        id = record.getId();
                    }
                    if (!freeIds || !record.isCreated()) continue;
                    this.getSchemaStore().freeId(record.getId());
                }
            }
        }
        finally {
            this.clear();
        }
    }

    private void removeRelationshipTypeFromCache(int id) {
        this.cacheAccess.removeRelationshipTypeFromCache(id);
    }

    private void patchDeletedRelationshipNodes(long id, long firstNodeId, long firstNodeNextRelId, long secondNodeId, long secondNextRelId) {
        this.cacheAccess.patchDeletedRelationshipNodes(id, firstNodeId, firstNodeNextRelId, secondNodeId, secondNextRelId);
    }

    private void removeRelationshipFromCache(long id) {
        this.cacheAccess.removeRelationshipFromCache(id);
    }

    private void removeNodeFromCache(long id) {
        this.cacheAccess.removeNodeFromCache(id);
    }

    private void removeGraphPropertiesFromCache() {
        this.cacheAccess.removeGraphPropertiesFromCache();
    }

    private void addRelationshipType(int id) {
        this.setRecovered();
        NameData type = this.isRecovered() ? this.neoStore.getRelationshipTypeStore().getName(id, true) : this.neoStore.getRelationshipTypeStore().getName(id);
        this.cacheAccess.addRelationshipType(type);
    }

    private void addPropertyIndexCommand(int id) {
        NameData index = this.isRecovered() ? this.neoStore.getPropertyStore().getIndexStore().getName(id, true) : this.neoStore.getPropertyStore().getIndexStore().getName(id);
        this.cacheAccess.addPropertyIndex(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCommit() throws XAException {
        if (!this.isRecovered() && !this.prepared) {
            throw new XAException("Cannot commit non prepared transaction[" + this.getIdentifier() + "]");
        }
        if (this.isRecovered()) {
            boolean wasInRecovery = this.neoStore.isInRecoveryMode();
            this.neoStore.setRecoveredStatus(true);
            try {
                this.applyCommit(true);
                return;
            }
            finally {
                this.neoStore.setRecoveredStatus(wasInRecovery);
            }
        }
        if (!this.isRecovered() && this.getCommitTxId() != this.neoStore.getLastCommittedTx() + 1L) {
            throw new RuntimeException("Tx id: " + this.getCommitTxId() + " not next transaction (" + this.neoStore.getLastCommittedTx() + ")");
        }
        this.applyCommit(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCommit(boolean isRecovered) {
        try {
            this.committed = true;
            CommandSorter sorter = new CommandSorter();
            if (this.relTypeCommands != null) {
                Collections.sort(this.relTypeCommands, sorter);
                for (Command.RelationshipTypeCommand relationshipTypeCommand : this.relTypeCommands) {
                    relationshipTypeCommand.execute();
                    if (!isRecovered) continue;
                    this.addRelationshipType((int)relationshipTypeCommand.getKey());
                }
            }
            if (this.propIndexCommands != null) {
                Collections.sort(this.propIndexCommands, sorter);
                for (Command.PropertyIndexCommand propertyIndexCommand : this.propIndexCommands) {
                    propertyIndexCommand.execute();
                    if (!isRecovered) continue;
                    this.addPropertyIndexCommand((int)propertyIndexCommand.getKey());
                }
            }
            Collections.sort(this.relCommands, sorter);
            Collections.sort(this.propCommands, sorter);
            this.executeCreated(isRecovered, this.propCommands, this.relCommands, this.nodeCommands.values());
            this.executeModified(isRecovered, this.propCommands, this.relCommands, this.nodeCommands.values());
            this.executeDeleted(this.propCommands, this.relCommands, this.nodeCommands.values());
            Iterable<NodePropertyUpdate> updates = this.convertIntoLogicalPropertyUpdates();
            this.indexes.updateIndexes(updates);
            block8: for (Command.SchemaRuleCommand command : this.schemaRuleCommands) {
                command.execute();
                switch (command.getMode()) {
                    case DELETE: {
                        this.cacheAccess.removeSchemaRuleFromCache(command.getKey());
                        continue block8;
                    }
                }
                this.cacheAccess.addSchemaRule(command.getSchemaRule());
            }
            if (this.neoStoreCommand != null) {
                this.neoStoreCommand.execute();
                if (isRecovered) {
                    this.removeGraphPropertiesFromCache();
                }
            }
            if (!isRecovered) {
                this.updateFirstRelationships();
                this.state.commitCows();
            }
            this.neoStore.setLastCommittedTx(this.getCommitTxId());
            if (isRecovered) {
                this.neoStore.updateIdGenerators();
            }
        }
        finally {
            this.clear();
        }
    }

    private Iterable<NodePropertyUpdate> convertIntoLogicalPropertyUpdates() {
        ArrayList<NodePropertyUpdate> updates = new ArrayList<NodePropertyUpdate>();
        this.gatherUpdatesFromPropertyCommands(updates);
        this.gatherUpdatesFromNodeCommands(updates);
        return updates;
    }

    private void gatherUpdatesFromPropertyCommands(Collection<NodePropertyUpdate> updates) {
        PropertyStore propertyStore = this.getPropertyStore();
        NodeStore nodeStore = this.getNodeStore();
        for (Command.PropertyCommand propertyCommand : this.propCommands) {
            long[] nodeLabelsAfter;
            long[] nodeLabelsBefore;
            PropertyRecord after = propertyCommand.getAfter();
            if (!after.isNodeSet()) continue;
            Command.NodeCommand nodeChanges = this.nodeCommands.get(after.getNodeId());
            if (nodeChanges != null) {
                nodeLabelsBefore = nodeStore.getLabelsForNode(nodeChanges.getBefore());
                nodeLabelsAfter = nodeStore.getLabelsForNode(nodeChanges.getAfter());
            } else {
                nodeLabelsBefore = nodeLabelsAfter = nodeStore.getLabelsForNode(nodeStore.getRecord(after.getNodeId()));
            }
            for (NodePropertyUpdate update : propertyStore.toLogicalUpdates(propertyCommand.getBefore(), nodeLabelsBefore, after, nodeLabelsAfter)) {
                updates.add(update);
            }
        }
    }

    private void gatherUpdatesFromNodeCommands(Collection<NodePropertyUpdate> updates) {
        NodeStore nodeStore = this.getNodeStore();
        for (Command.NodeCommand nodeCommand : this.nodeCommands.values()) {
            ArrayMap<Integer, PropertyData> properties;
            long[] labelsAfter;
            long nodeId = nodeCommand.getKey();
            long[] labelsBefore = nodeStore.getLabelsForNode(nodeCommand.getBefore());
            for (long labelAfter : labelsAfter = nodeStore.getLabelsForNode(nodeCommand.getAfter())) {
                if (Arrays.binarySearch(labelsBefore, labelAfter) >= 0) continue;
                properties = this.nodeFullyLoadProperties(nodeId);
                for (PropertyData property : properties.values()) {
                    updates.add(NodePropertyUpdate.add(nodeId, property.getIndex(), property.getValue(), new long[]{labelAfter}));
                }
            }
            for (long labelBefore : labelsBefore) {
                if (Arrays.binarySearch(labelsAfter, labelBefore) >= 0) continue;
                properties = this.nodeFullyLoadProperties(nodeId);
                for (PropertyData property : properties.values()) {
                    updates.add(NodePropertyUpdate.remove(nodeId, property.getIndex(), property.getValue(), new long[]{labelBefore}));
                }
            }
        }
    }

    @Override
    public boolean delistResource(Transaction tx, int tmsuccess) throws SystemException {
        return this.xaConnection.delistResource(tx, tmsuccess);
    }

    private void updateFirstRelationships() {
        for (RecordChanges.RecordChange<Long, NodeRecord, Void> change : this.nodeRecords.changes()) {
            NodeRecord record = change.forReadingLinkage();
            this.state.setFirstIds(record.getId(), record.getNextRel(), record.getNextProp());
        }
    }

    private void executeCreated(boolean removeFromCache, Collection<? extends Command> ... commands) {
        for (Collection<? extends Command> c : commands) {
            for (Command command : c) {
                if (command.getMode() != Command.Mode.CREATE) continue;
                command.execute();
                if (!removeFromCache) continue;
                command.removeFromCache(this.cacheAccess);
            }
        }
    }

    private void executeModified(boolean removeFromCache, Collection<? extends Command> ... commands) {
        for (Collection<? extends Command> c : commands) {
            for (Command command : c) {
                if (command.getMode() != Command.Mode.UPDATE) continue;
                command.execute();
                if (!removeFromCache) continue;
                command.removeFromCache(this.cacheAccess);
            }
        }
    }

    private void executeDeleted(Collection<? extends Command> ... commands) {
        for (Collection<? extends Command> c : commands) {
            for (Command command : c) {
                if (command.getMode() != Command.Mode.DELETE) continue;
                command.execute();
                command.removeFromCache(this.cacheAccess);
            }
        }
    }

    private void clear() {
        this.nodeRecords.clear();
        this.propertyRecords.clear();
        this.relRecords.clear();
        this.schemaRuleRecords.clear();
        this.relTypeRecords = null;
        this.propIndexRecords = null;
        this.neoStoreRecord = null;
        this.nodeCommands.clear();
        this.propCommands.clear();
        this.propIndexCommands = null;
        this.relCommands.clear();
        this.schemaRuleCommands.clear();
        this.relTypeCommands = null;
        this.neoStoreCommand = null;
    }

    private RelationshipTypeStore getRelationshipTypeStore() {
        return this.neoStore.getRelationshipTypeStore();
    }

    private int getRelGrabSize() {
        return this.neoStore.getRelationshipGrabSize();
    }

    private NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    private SchemaStore getSchemaStore() {
        return this.neoStore.getSchemaStore();
    }

    private RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    private PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    @Override
    public NodeRecord nodeLoadLight(long nodeId) {
        try {
            return this.nodeRecords.getOrLoad(nodeId, null).forReadingLinkage();
        }
        catch (InvalidRecordException e) {
            return null;
        }
    }

    @Override
    public RelationshipRecord relLoadLight(long id) {
        try {
            return this.relRecords.getOrLoad(id, null).forReadingLinkage();
        }
        catch (InvalidRecordException e) {
            return null;
        }
    }

    @Override
    public ArrayMap<Integer, PropertyData> nodeDelete(long nodeId) {
        NodeRecord nodeRecord = this.nodeRecords.getOrLoad(nodeId, null).forChangingData();
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Unable to delete Node[" + nodeId + "] since it has already been deleted.");
        }
        nodeRecord.setInUse(false);
        ArrayMap<Integer, PropertyData> propertyMap = this.getAndDeletePropertyChain(nodeRecord);
        return propertyMap;
    }

    @Override
    public ArrayMap<Integer, PropertyData> relDelete(long id) {
        RelationshipRecord record = this.relRecords.getOrLoad(id, null).forChangingLinkage();
        if (!record.inUse()) {
            throw new IllegalStateException("Unable to delete relationship[" + id + "] since it is already deleted.");
        }
        ArrayMap<Integer, PropertyData> propertyMap = this.getAndDeletePropertyChain(record);
        this.disconnectRelationship(record);
        this.updateNodes(record);
        record.setInUse(false);
        return propertyMap;
    }

    private ArrayMap<Integer, PropertyData> getAndDeletePropertyChain(PrimitiveRecord primitive) {
        ArrayMap<Integer, PropertyData> result = new ArrayMap<Integer, PropertyData>(9, false, true);
        long nextProp = primitive.getNextProp();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            RecordChanges.RecordChange<Long, PropertyRecord, PrimitiveRecord> propertyChange = this.propertyRecords.getOrLoad(nextProp, primitive);
            PropertyRecord propRecord = propertyChange.forChangingData();
            PropertyRecord before = propertyChange.getBefore();
            for (PropertyBlock block : before.getPropertyBlocks()) {
                result.put(block.getKeyIndexId(), block.newPropertyData(propRecord, this.propertyGetValueOrNull(block)));
            }
            for (PropertyBlock block : propRecord.getPropertyBlocks()) {
                for (DynamicRecord valueRecord : block.getValueRecords()) {
                    assert (valueRecord.inUse());
                    valueRecord.setInUse(false);
                    propRecord.addDeletedRecord(valueRecord);
                }
            }
            nextProp = propRecord.getNextProp();
            propRecord.setInUse(false);
            propRecord.setChanged(primitive);
            propRecord.getPropertyBlocks().clear();
        }
        return result;
    }

    private void disconnectRelationship(RelationshipRecord rel) {
        RelationshipRecord nextRel;
        boolean changed;
        RelationshipRecord prevRel;
        LockableRelationship lockableRel;
        if (rel.getFirstPrevRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            lockableRel = new LockableRelationship(rel.getFirstPrevRel());
            this.getWriteLock(lockableRel);
            prevRel = this.relRecords.getOrLoad(rel.getFirstPrevRel(), null).forChangingLinkage();
            changed = false;
            if (prevRel.getFirstNode() == rel.getFirstNode()) {
                prevRel.setFirstNextRel(rel.getFirstNextRel());
                changed = true;
            }
            if (prevRel.getSecondNode() == rel.getFirstNode()) {
                prevRel.setSecondNextRel(rel.getFirstNextRel());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(prevRel + " don't match " + rel);
            }
        }
        if (rel.getFirstNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            lockableRel = new LockableRelationship(rel.getFirstNextRel());
            this.getWriteLock(lockableRel);
            nextRel = this.relRecords.getOrLoad(rel.getFirstNextRel(), null).forChangingLinkage();
            changed = false;
            if (nextRel.getFirstNode() == rel.getFirstNode()) {
                nextRel.setFirstPrevRel(rel.getFirstPrevRel());
                changed = true;
            }
            if (nextRel.getSecondNode() == rel.getFirstNode()) {
                nextRel.setSecondPrevRel(rel.getFirstPrevRel());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(nextRel + " don't match " + rel);
            }
        }
        if (rel.getSecondPrevRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            lockableRel = new LockableRelationship(rel.getSecondPrevRel());
            this.getWriteLock(lockableRel);
            prevRel = this.relRecords.getOrLoad(rel.getSecondPrevRel(), null).forChangingLinkage();
            changed = false;
            if (prevRel.getFirstNode() == rel.getSecondNode()) {
                prevRel.setFirstNextRel(rel.getSecondNextRel());
                changed = true;
            }
            if (prevRel.getSecondNode() == rel.getSecondNode()) {
                prevRel.setSecondNextRel(rel.getSecondNextRel());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(prevRel + " don't match " + rel);
            }
        }
        if (rel.getSecondNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            lockableRel = new LockableRelationship(rel.getSecondNextRel());
            this.getWriteLock(lockableRel);
            nextRel = this.relRecords.getOrLoad(rel.getSecondNextRel(), null).forChangingLinkage();
            changed = false;
            if (nextRel.getFirstNode() == rel.getSecondNode()) {
                nextRel.setFirstPrevRel(rel.getSecondPrevRel());
                changed = true;
            }
            if (nextRel.getSecondNode() == rel.getSecondNode()) {
                nextRel.setSecondPrevRel(rel.getSecondPrevRel());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(nextRel + " don't match " + rel);
            }
        }
    }

    private void getWriteLock(Relationship lockableRel) {
        this.state.acquireWriteLock(lockableRel);
    }

    @Override
    public long getRelationshipChainPosition(long nodeId) {
        return this.nodeRecords.getOrLoad(nodeId, null).getBefore().getNextRel();
    }

    @Override
    public Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, Long> getMoreRelationships(long nodeId, long position) {
        return ReadTransaction.getMoreRelationships(nodeId, position, this.getRelGrabSize(), this.getRelationshipStore());
    }

    private void updateNodes(RelationshipRecord rel) {
        if (rel.getFirstPrevRel() == (long)Record.NO_PREV_RELATIONSHIP.intValue()) {
            NodeRecord firstNode = this.nodeRecords.getOrLoad(rel.getFirstNode(), null).forChangingLinkage();
            firstNode.setNextRel(rel.getFirstNextRel());
        }
        if (rel.getSecondPrevRel() == (long)Record.NO_PREV_RELATIONSHIP.intValue()) {
            NodeRecord secondNode = this.nodeRecords.getOrLoad(rel.getSecondNode(), null).forChangingLinkage();
            secondNode.setNextRel(rel.getSecondNextRel());
        }
    }

    @Override
    public void relRemoveProperty(long relId, PropertyData propertyData) {
        RecordChanges.RecordChange<Long, RelationshipRecord, Object> rel = this.relRecords.getOrLoad(relId, null);
        RelationshipRecord relRecord = rel.forReadingLinkage();
        if (!relRecord.inUse()) {
            throw new IllegalStateException("Property remove on relationship[" + relId + "] illegal since it has been deleted.");
        }
        assert (this.assertPropertyChain(relRecord));
        this.removeProperty(rel, propertyData);
    }

    @Override
    public ArrayMap<Integer, PropertyData> relLoadProperties(long relId, boolean light) {
        RelationshipRecord relRecord;
        RecordChanges.RecordChange<Long, RelationshipRecord, Void> rel = this.relRecords.getIfLoaded(relId);
        if (rel != null) {
            if (rel.isCreated()) {
                return ArrayMap.empty();
            }
            if (!rel.forReadingLinkage().inUse() && !light) {
                throw new IllegalStateException("Relationship[" + relId + "] has been deleted in this tx");
            }
        }
        if (!(relRecord = this.relRecords.getOrLoad(relId, null).forReadingLinkage()).inUse()) {
            throw new InvalidRecordException("Relationship[" + relId + "] not in use");
        }
        return ReadTransaction.loadProperties(this.getPropertyStore(), relRecord.getNextProp());
    }

    private ArrayMap<Integer, PropertyData> nodeFullyLoadProperties(long nodeId) {
        ArrayMap<Integer, PropertyData> properties = this.nodeLoadProperties(nodeId, false);
        for (PropertyData propertyData : properties.values()) {
            if (propertyData.getValue() != null) continue;
            propertyData.setNewValue(this.loadPropertyValue(propertyData));
        }
        return properties;
    }

    @Override
    public ArrayMap<Integer, PropertyData> nodeLoadProperties(long nodeId, boolean light) {
        NodeRecord nodeRecord;
        RecordChanges.RecordChange<Long, NodeRecord, Void> node = this.nodeRecords.getIfLoaded(nodeId);
        if (node != null) {
            if (node.isCreated()) {
                return ArrayMap.empty();
            }
            if (!node.forReadingLinkage().inUse() && !light) {
                throw new IllegalStateException("Node[" + nodeId + "] has been deleted in this tx");
            }
        }
        if (!(nodeRecord = this.nodeRecords.getOrLoad(nodeId, null).forReadingLinkage()).inUse()) {
            throw new IllegalStateException("Node[" + nodeId + "] has been deleted in this tx");
        }
        return ReadTransaction.loadProperties(this.getPropertyStore(), nodeRecord.getNextProp());
    }

    public Object propertyGetValueOrNull(PropertyBlock block) {
        return block.getType().getValue(block, block.isLight() ? null : this.getPropertyStore());
    }

    @Override
    public Object loadPropertyValue(PropertyData propertyData) {
        RecordChanges.RecordChange<Long, PropertyRecord, Object> propertyChange = this.propertyRecords.getOrLoad(propertyData.getId(), null);
        PropertyRecord propertyRecord = propertyChange.forReadingData();
        PropertyBlock block = propertyRecord.getPropertyBlock(propertyData.getIndex());
        if (block == null) {
            throw new IllegalStateException("Property with index[" + propertyData.getIndex() + "] is not present in property[" + propertyData.getId() + "]");
        }
        return block.getType().getValue(block, this.getPropertyStore());
    }

    @Override
    public void nodeRemoveProperty(long nodeId, PropertyData propertyData) {
        RecordChanges.RecordChange<Long, NodeRecord, Object> node = this.nodeRecords.getOrLoad(nodeId, null);
        NodeRecord nodeRecord = node.forReadingLinkage();
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Property remove on node[" + nodeId + "] illegal since it has been deleted.");
        }
        assert (this.assertPropertyChain(nodeRecord));
        this.removeProperty(node, propertyData);
    }

    private <P extends PrimitiveRecord> void removeProperty(RecordChanges.RecordChange<Long, P, Void> primitiveRecordChange, PropertyData propertyData) {
        long propertyId = propertyData.getId();
        RecordChanges.RecordChange<Long, PropertyRecord, PrimitiveRecord> recordChange = this.propertyRecords.getOrLoad(propertyId, (PrimitiveRecord)primitiveRecordChange.forReadingLinkage());
        PropertyRecord propRecord = recordChange.forChangingData();
        if (!propRecord.inUse()) {
            throw new IllegalStateException("Unable to delete property[" + propertyId + "] since it is already deleted.");
        }
        PropertyBlock block = propRecord.removePropertyBlock(propertyData.getIndex());
        if (block == null) {
            throw new IllegalStateException("Property with index[" + propertyData.getIndex() + "] is not present in property[" + propertyId + "]");
        }
        for (DynamicRecord valueRecord : block.getValueRecords()) {
            assert (valueRecord.inUse());
            valueRecord.setInUse(false, block.getType().intValue());
            propRecord.addDeletedRecord(valueRecord);
        }
        if (propRecord.size() > 0) {
            propRecord.setChanged((PrimitiveRecord)primitiveRecordChange.forReadingLinkage());
            assert (this.assertPropertyChain((PrimitiveRecord)primitiveRecordChange.forReadingLinkage()));
        } else {
            this.unlinkPropertyRecord(propRecord, primitiveRecordChange);
        }
    }

    private <P extends PrimitiveRecord> void unlinkPropertyRecord(PropertyRecord propRecord, RecordChanges.RecordChange<Long, P, Void> primitiveRecordChange) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveRecordChange.forReadingLinkage();
        assert (this.assertPropertyChain(primitive));
        assert (propRecord.size() == 0);
        long prevProp = propRecord.getPrevProp();
        long nextProp = propRecord.getNextProp();
        if (primitive.getNextProp() == propRecord.getId()) {
            assert (propRecord.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue()) : propRecord + " for " + primitive;
            ((PrimitiveRecord)primitiveRecordChange.forChangingLinkage()).setNextProp(nextProp);
        }
        if (prevProp != (long)Record.NO_PREVIOUS_PROPERTY.intValue()) {
            PropertyRecord prevPropRecord = this.propertyRecords.getOrLoad(prevProp, primitive).forChangingLinkage();
            assert (prevPropRecord.inUse()) : prevPropRecord + "->" + propRecord + " for " + primitive;
            prevPropRecord.setNextProp(nextProp);
            prevPropRecord.setChanged(primitive);
        }
        if (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord nextPropRecord = this.propertyRecords.getOrLoad(nextProp, primitive).forChangingLinkage();
            assert (nextPropRecord.inUse()) : propRecord + "->" + nextPropRecord + " for " + primitive;
            nextPropRecord.setPrevProp(prevProp);
            nextPropRecord.setChanged(primitive);
        }
        propRecord.setInUse(false);
        propRecord.setPrevProp(Record.NO_PREVIOUS_PROPERTY.intValue());
        propRecord.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
        propRecord.setChanged(primitive);
        assert (this.assertPropertyChain(primitive));
    }

    @Override
    public PropertyData relChangeProperty(long relId, PropertyData propertyData, Object value) {
        RecordChanges.RecordChange<Long, RelationshipRecord, Object> rel = this.relRecords.getOrLoad(relId, null);
        if (!rel.forReadingLinkage().inUse()) {
            throw new IllegalStateException("Property change on relationship[" + relId + "] illegal since it has been deleted.");
        }
        return this.primitiveChangeProperty(rel, propertyData, value);
    }

    @Override
    public PropertyData nodeChangeProperty(long nodeId, PropertyData propertyData, Object value) {
        RecordChanges.RecordChange<Long, NodeRecord, Object> node = this.nodeRecords.getOrLoad(nodeId, null);
        if (!node.forReadingLinkage().inUse()) {
            throw new IllegalStateException("Property change on node[" + nodeId + "] illegal since it has been deleted.");
        }
        return this.primitiveChangeProperty(node, propertyData, value);
    }

    private <P extends PrimitiveRecord> PropertyData primitiveChangeProperty(RecordChanges.RecordChange<Long, P, Void> primitiveRecordChange, PropertyData propertyData, Object value) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveRecordChange.forReadingLinkage();
        assert (this.assertPropertyChain(primitive));
        long propertyId = propertyData.getId();
        PropertyRecord propertyRecord = this.propertyRecords.getOrLoad(propertyId, primitive).forChangingData();
        if (!propertyRecord.inUse()) {
            throw new IllegalStateException("Unable to change property[" + propertyId + "] since it has been deleted.");
        }
        PropertyBlock block = propertyRecord.getPropertyBlock(propertyData.getIndex());
        if (block == null) {
            throw new IllegalStateException("Property with index[" + propertyData.getIndex() + "] is not present in property[" + propertyId + "]");
        }
        propertyRecord.setChanged(primitive);
        for (DynamicRecord record : block.getValueRecords()) {
            assert (record.inUse());
            record.setInUse(false, block.getType().intValue());
            propertyRecord.addDeletedRecord(record);
        }
        this.getPropertyStore().encodeValue(block, propertyData.getIndex(), value);
        if (propertyRecord.size() > PropertyType.getPayloadSize()) {
            propertyRecord.removePropertyBlock(propertyData.getIndex());
            propertyRecord = this.addPropertyBlockToPrimitive(block, primitiveRecordChange);
        }
        assert (this.assertPropertyChain(primitive));
        return block.newPropertyData(propertyRecord, value);
    }

    private <P extends PrimitiveRecord> PropertyData addPropertyToPrimitive(RecordChanges.RecordChange<Long, P, Void> primitive, PropertyIndex index, Object value) {
        PrimitiveRecord record = (PrimitiveRecord)primitive.forReadingLinkage();
        assert (this.assertPropertyChain(record));
        PropertyBlock block = new PropertyBlock();
        block.setCreated();
        this.getPropertyStore().encodeValue(block, index.getKeyId(), value);
        PropertyRecord host = this.addPropertyBlockToPrimitive(block, primitive);
        assert (this.assertPropertyChain(record));
        return block.newPropertyData(host, value);
    }

    @Override
    public PropertyData relAddProperty(long relId, PropertyIndex index, Object value) {
        RecordChanges.RecordChange<Long, RelationshipRecord, Object> rel = this.relRecords.getOrLoad(relId, null);
        RelationshipRecord relRecord = rel.forReadingLinkage();
        if (!relRecord.inUse()) {
            throw new IllegalStateException("Property add on relationship[" + relId + "] illegal since it has been deleted.");
        }
        return this.addPropertyToPrimitive(rel, index, value);
    }

    @Override
    public PropertyData nodeAddProperty(long nodeId, PropertyIndex index, Object value) {
        RecordChanges.RecordChange<Long, NodeRecord, Object> node = this.nodeRecords.getOrLoad(nodeId, null);
        NodeRecord nodeRecord = node.forReadingLinkage();
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Property add on node[" + nodeId + "] illegal since it has been deleted.");
        }
        return this.addPropertyToPrimitive(node, index, value);
    }

    private <P extends PrimitiveRecord> PropertyRecord addPropertyBlockToPrimitive(PropertyBlock block, RecordChanges.RecordChange<Long, P, Void> primitiveRecordChange) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveRecordChange.forReadingLinkage();
        assert (this.assertPropertyChain(primitive));
        int newBlockSizeInBytes = block.getSize();
        PropertyRecord host = null;
        long firstProp = primitive.getNextProp();
        if (firstProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            RecordChanges.RecordChange<Long, PropertyRecord, PrimitiveRecord> change = this.propertyRecords.getOrLoad(firstProp, primitive);
            PropertyRecord propRecord = change.forReadingLinkage();
            assert (propRecord.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue()) : propRecord + " for " + primitive;
            assert (propRecord.inUse()) : propRecord;
            int propSize = propRecord.size();
            assert (propSize > 0) : propRecord;
            if (propSize + newBlockSizeInBytes <= PropertyType.getPayloadSize()) {
                host = propRecord = change.forChangingData();
                host.addPropertyBlock(block);
                host.setChanged(primitive);
            }
        }
        if (host == null) {
            host = this.propertyRecords.create(this.getPropertyStore().nextId(), primitive).forChangingData();
            if (primitive.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                PropertyRecord prevProp = this.propertyRecords.getOrLoad(primitive.getNextProp(), primitive).forChangingLinkage();
                assert (prevProp.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue());
                prevProp.setPrevProp(host.getId());
                host.setNextProp(prevProp.getId());
                prevProp.setChanged(primitive);
            }
            ((PrimitiveRecord)primitiveRecordChange.forChangingLinkage()).setNextProp(host.getId());
            host.addPropertyBlock(block);
            host.setInUse(true);
        }
        assert (this.assertPropertyChain(primitive));
        return host;
    }

    @Override
    public void relationshipCreate(long id, int type, long firstNodeId, long secondNodeId) {
        NodeRecord firstNode = this.nodeRecords.getOrLoad(firstNodeId, null).forChangingLinkage();
        if (!firstNode.inUse()) {
            throw new IllegalStateException("First node[" + firstNodeId + "] is deleted and cannot be used to create a relationship");
        }
        NodeRecord secondNode = this.nodeRecords.getOrLoad(secondNodeId, null).forChangingLinkage();
        if (!secondNode.inUse()) {
            throw new IllegalStateException("Second node[" + secondNodeId + "] is deleted and cannot be used to create a relationship");
        }
        RelationshipRecord record = this.relRecords.create(id, null).forChangingLinkage();
        record.setLinks(firstNodeId, secondNodeId, type);
        record.setInUse(true);
        record.setCreated();
        this.connectRelationship(firstNode, secondNode, record);
    }

    private void connectRelationship(NodeRecord firstNode, NodeRecord secondNode, RelationshipRecord rel) {
        assert (firstNode.getNextRel() != rel.getId());
        assert (secondNode.getNextRel() != rel.getId());
        rel.setFirstNextRel(firstNode.getNextRel());
        rel.setSecondNextRel(secondNode.getNextRel());
        this.connect(firstNode, rel);
        this.connect(secondNode, rel);
        firstNode.setNextRel(rel.getId());
        secondNode.setNextRel(rel.getId());
    }

    private void connect(NodeRecord node, RelationshipRecord rel) {
        if (node.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            LockableRelationship lockableRel = new LockableRelationship(node.getNextRel());
            this.getWriteLock(lockableRel);
            RelationshipRecord nextRel = this.relRecords.getOrLoad(node.getNextRel(), null).forChangingLinkage();
            boolean changed = false;
            if (nextRel.getFirstNode() == node.getId()) {
                nextRel.setFirstPrevRel(rel.getId());
                changed = true;
            }
            if (nextRel.getSecondNode() == node.getId()) {
                nextRel.setSecondPrevRel(rel.getId());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(node + " dont match " + nextRel);
            }
        }
    }

    @Override
    public void nodeCreate(long nodeId) {
        NodeRecord nodeRecord = this.nodeRecords.create(nodeId, null).forChangingData();
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
    }

    @Override
    public String loadIndex(int id) {
        PropertyIndexStore indexStore = this.getPropertyStore().getIndexStore();
        PropertyIndexRecord index = this.getPropertyIndexRecord(id);
        if (index == null) {
            index = (PropertyIndexRecord)indexStore.getRecord(id);
        }
        indexStore.ensureHeavy(index);
        return indexStore.getStringFor(index);
    }

    @Override
    public NameData[] loadPropertyIndexes() {
        PropertyIndexStore indexStore = this.getPropertyStore().getIndexStore();
        return indexStore.getNames(Integer.MAX_VALUE);
    }

    @Override
    public void createPropertyIndex(String key, int id) {
        PropertyIndexRecord record = new PropertyIndexRecord(id);
        record.setInUse(true);
        record.setCreated();
        PropertyIndexStore propIndexStore = this.getPropertyStore().getIndexStore();
        Collection<DynamicRecord> nameRecords = propIndexStore.allocateNameRecords(PropertyStore.encodeString(key));
        record.setNameId((int)IteratorUtil.first(nameRecords).getId());
        for (DynamicRecord keyRecord : nameRecords) {
            record.addNameRecord(keyRecord);
        }
        this.addPropertyIndexRecord(record);
    }

    @Override
    public void createRelationshipType(int id, String name) {
        RelationshipTypeRecord record = new RelationshipTypeRecord(id);
        record.setInUse(true);
        record.setCreated();
        Collection<DynamicRecord> typeNameRecords = this.getRelationshipTypeStore().allocateNameRecords(PropertyStore.encodeString(name));
        record.setNameId((int)IteratorUtil.first(typeNameRecords).getId());
        for (DynamicRecord typeRecord : typeNameRecords) {
            record.addNameRecord(typeRecord);
        }
        this.addRelationshipTypeRecord(record);
    }

    void addRelationshipTypeRecord(RelationshipTypeRecord record) {
        if (this.relTypeRecords == null) {
            this.relTypeRecords = new HashMap<Integer, RelationshipTypeRecord>();
        }
        this.relTypeRecords.put(record.getId(), record);
    }

    void addPropertyIndexRecord(PropertyIndexRecord record) {
        if (this.propIndexRecords == null) {
            this.propIndexRecords = new HashMap<Integer, PropertyIndexRecord>();
        }
        this.propIndexRecords.put(record.getId(), record);
    }

    PropertyIndexRecord getPropertyIndexRecord(int id) {
        return this.propIndexRecords != null ? this.propIndexRecords.get(id) : null;
    }

    @Override
    public int getKeyIdForProperty(PropertyData property) {
        return ReadTransaction.getKeyIdForProperty(property, this.getPropertyStore());
    }

    @Override
    public void destroy() {
        this.xaConnection.destroy();
    }

    @Override
    public void setXaConnection(XaConnection connection) {
        this.xaConnection = connection;
    }

    @Override
    public NameData[] loadRelationshipTypes() {
        NameData[] relTypeData = this.neoStore.getRelationshipTypeStore().getNames(Integer.MAX_VALUE);
        NameData[] rawRelTypeData = new NameData[relTypeData.length];
        for (int i = 0; i < relTypeData.length; ++i) {
            rawRelTypeData[i] = new NameData(relTypeData[i].getId(), relTypeData[i].getName());
        }
        return rawRelTypeData;
    }

    private boolean assertPropertyChain(PrimitiveRecord primitive) {
        LinkedList<PropertyRecord> toCheck = new LinkedList<PropertyRecord>();
        long nextIdToFetch = primitive.getNextProp();
        while (nextIdToFetch != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = this.propertyRecords.getOrLoad(nextIdToFetch, primitive).forReadingLinkage();
            toCheck.add(propRecord);
            assert (propRecord.inUse()) : primitive + "->" + Arrays.toString(toCheck.toArray());
            nextIdToFetch = propRecord.getNextProp();
        }
        if (toCheck.isEmpty()) {
            assert (primitive.getNextProp() == (long)Record.NO_NEXT_PROPERTY.intValue()) : primitive;
            return true;
        }
        PropertyRecord first = (PropertyRecord)toCheck.get(0);
        PropertyRecord last = (PropertyRecord)toCheck.get(toCheck.size() - 1);
        assert (first.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue()) : primitive + "->" + Arrays.toString(toCheck.toArray());
        assert (last.getNextProp() == (long)Record.NO_NEXT_PROPERTY.intValue()) : primitive + "->" + Arrays.toString(toCheck.toArray());
        PropertyRecord previous = first;
        for (int i = 1; i < toCheck.size(); ++i) {
            PropertyRecord current = (PropertyRecord)toCheck.get(i);
            assert (current.getPrevProp() == previous.getId()) : primitive + "->" + Arrays.toString(toCheck.toArray());
            assert (previous.getNextProp() == current.getId()) : primitive + "->" + Arrays.toString(toCheck.toArray());
            previous = current;
        }
        return true;
    }

    private RecordChanges.RecordChange<Long, NeoStoreRecord, Void> getOrLoadNeoStoreRecord() {
        if (this.neoStoreRecord == null) {
            this.neoStoreRecord = new RecordChanges<Long, NeoStoreRecord, Void>(new RecordChanges.Loader<Long, NeoStoreRecord, Void>(){

                @Override
                public NeoStoreRecord newUnused(Long key, Void additionalData) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public NeoStoreRecord load(Long key, Void additionalData) {
                    return WriteTransaction.this.neoStore.asRecord();
                }

                @Override
                public void ensureHeavy(NeoStoreRecord record) {
                }
            }, false);
        }
        return this.neoStoreRecord.getOrLoad(0L, null);
    }

    @Override
    public PropertyData graphAddProperty(PropertyIndex index, Object value) {
        PropertyBlock block = new PropertyBlock();
        block.setCreated();
        this.getPropertyStore().encodeValue(block, index.getKeyId(), value);
        RecordChanges.RecordChange<Long, NeoStoreRecord, Void> change = this.getOrLoadNeoStoreRecord();
        PropertyRecord host = this.addPropertyBlockToPrimitive(block, change);
        assert (this.assertPropertyChain(change.forReadingLinkage()));
        return block.newPropertyData(host, value);
    }

    @Override
    public PropertyData graphChangeProperty(PropertyData propertyData, Object value) {
        return this.primitiveChangeProperty(this.getOrLoadNeoStoreRecord(), propertyData, value);
    }

    @Override
    public void graphRemoveProperty(PropertyData propertyData) {
        this.removeProperty(this.getOrLoadNeoStoreRecord(), propertyData);
    }

    @Override
    public ArrayMap<Integer, PropertyData> graphLoadProperties(boolean light) {
        return ReadTransaction.loadProperties(this.getPropertyStore(), this.getOrLoadNeoStoreRecord().forReadingLinkage().getNextProp());
    }

    @Override
    public void createSchemaRule(SchemaRule schemaRule) {
        Collection<DynamicRecord> records = this.getSchemaStore().allocateFrom(schemaRule);
        this.addSchemaRule(IteratorUtil.first(records).getId(), Pair.of(records, schemaRule));
    }

    @Override
    public void dropSchemaRule(long ruleId) {
        Pair<Collection<DynamicRecord>, SchemaRule> pair = this.schemaRuleRecords.get(ruleId);
        if (pair == null) {
            Collection<DynamicRecord> records = this.getSchemaStore().getRecords(ruleId);
            pair = Pair.of(records, this.deserializeSchemaRule(ruleId, records));
            this.addSchemaRule(ruleId, pair);
        }
        for (DynamicRecord record : pair.first()) {
            record.setInUse(false);
        }
    }

    private SchemaRule deserializeSchemaRule(long ruleId, Collection<DynamicRecord> records) {
        return SchemaRule.Kind.deserialize(ruleId, AbstractDynamicStore.concatData(records, new byte[100]));
    }

    private void addSchemaRule(long id, Pair<Collection<DynamicRecord>, SchemaRule> schemaRule) {
        this.schemaRuleRecords.put(id, schemaRule);
    }

    @Override
    public void addLabelToNode(long labelId, long nodeId) {
        NodeRecord nodeRecord = this.nodeRecords.getOrLoad(nodeId, null).forChangingData();
        NodeLabelRecordLogic manipulator = new NodeLabelRecordLogic(nodeRecord, this.getNodeStore());
        manipulator.add(labelId);
    }

    @Override
    public void removeLabelFromNode(long labelId, long nodeId) {
        NodeRecord nodeRecord = this.nodeRecords.getOrLoad(nodeId, null).forChangingData();
        NodeLabelRecordLogic manipulator = new NodeLabelRecordLogic(nodeRecord, this.getNodeStore());
        manipulator.remove(labelId);
    }

    @Override
    public Iterator<Long> getLabelsForNode(long nodeId) {
        NodeRecord node = this.getNodeStore().getRecord(nodeId);
        return IteratorUtil.asIterator(this.getNodeStore().getLabelsForNode(node));
    }

    private static class LockableRelationship
    implements Relationship {
        private final long id;

        LockableRelationship(long id) {
            this.id = id;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node getEndNode() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public GraphDatabaseService getGraphDatabase() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node[] getNodes() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node getOtherNode(Node node) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Object getProperty(String key) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Object getProperty(String key, Object defaultValue) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Iterable<String> getPropertyKeys() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Iterable<Object> getPropertyValues() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node getStartNode() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public RelationshipType getType() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public boolean isType(RelationshipType type) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public boolean hasProperty(String key) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Object removeProperty(String key) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public void setProperty(String key, Object value) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        public boolean equals(Object o) {
            if (!(o instanceof Relationship)) {
                return false;
            }
            return this.getId() == ((Relationship)o).getId();
        }

        public int hashCode() {
            return (int)(this.id >>> 32 ^ this.id);
        }

        public String toString() {
            return "Lockable relationship #" + this.getId();
        }
    }

    static class CommandSorter
    implements Comparator<Command>,
    Serializable {
        CommandSorter() {
        }

        @Override
        public int compare(Command o1, Command o2) {
            long id2;
            long id1 = o1.getKey();
            long diff = id1 - (id2 = o2.getKey());
            if (diff > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (diff < Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return (int)diff;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof CommandSorter;
        }

        public int hashCode() {
            return 3217;
        }
    }
}

