/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.ConstraintViolationKernelException;
import org.neo4j.kernel.api.LabelNotFoundKernelException;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.traversal.OldTraverserWrapper;

public class NodeProxy
implements Node {
    private final NodeLookup nodeLookup;
    private final ThreadToStatementContextBridge statementCtxProvider;
    private final long nodeId;

    NodeProxy(long nodeId, NodeLookup nodeLookup, ThreadToStatementContextBridge statementCtxProvider) {
        this.nodeId = nodeId;
        this.nodeLookup = nodeLookup;
        this.statementCtxProvider = statementCtxProvider;
    }

    @Override
    public long getId() {
        return this.nodeId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.nodeLookup.getGraphDatabase();
    }

    @Override
    public void delete() {
        this.nodeLookup.lookup(this.nodeId, LockType.WRITE).delete(this.nodeLookup.getNodeManager(), this);
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager());
    }

    @Override
    public boolean hasRelationship() {
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager());
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction dir) {
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), dir);
    }

    @Override
    public boolean hasRelationship(Direction dir) {
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), dir);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), types);
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), direction, types);
    }

    @Override
    public boolean hasRelationship(RelationshipType ... types) {
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), types);
    }

    @Override
    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), direction, types);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), type, dir);
    }

    @Override
    public boolean hasRelationship(RelationshipType type, Direction dir) {
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), type, dir);
    }

    @Override
    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        return this.nodeLookup.lookup(this.nodeId).getSingleRelationship(this.nodeLookup.getNodeManager(), type, dir);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.nodeLookup.lookup(this.nodeId, LockType.WRITE).setProperty(this.nodeLookup.getNodeManager(), this, key, value);
    }

    @Override
    public Object removeProperty(String key) throws NotFoundException {
        return this.nodeLookup.lookup(this.nodeId, LockType.WRITE).removeProperty(this.nodeLookup.getNodeManager(), this, key);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        return this.nodeLookup.lookup(this.nodeId).getProperty(this.nodeLookup.getNodeManager(), key, defaultValue);
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        return this.nodeLookup.lookup(this.nodeId).getPropertyValues(this.nodeLookup.getNodeManager());
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return this.nodeLookup.lookup(this.nodeId).getPropertyKeys(this.nodeLookup.getNodeManager());
    }

    @Override
    public Object getProperty(String key) throws NotFoundException {
        return this.nodeLookup.lookup(this.nodeId).getProperty(this.nodeLookup.getNodeManager(), key);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.nodeLookup.lookup(this.nodeId).hasProperty(this.nodeLookup.getNodeManager(), key);
    }

    public int compareTo(Object node) {
        long theirId;
        Node n = (Node)node;
        long ourId = this.getId();
        if (ourId < (theirId = n.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Node)) {
            return false;
        }
        return this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return (int)(this.nodeId >>> 32 ^ this.nodeId);
    }

    public String toString() {
        return "Node[" + this.getId() + "]";
    }

    @Override
    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        return this.nodeLookup.lookup(this.nodeId, LockType.WRITE).createRelationshipTo(this.nodeLookup.getNodeManager(), this, otherNode, type);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{relationshipType, direction});
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{firstRelationshipType, firstDirection, secondRelationshipType, secondDirection});
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, relationshipTypesAndDirections);
    }

    @Override
    public void addLabel(Label label) {
        StatementContext ctx = this.statementCtxProvider.getCtxForWriting();
        try {
            ctx.addLabelToNode(ctx.getOrCreateLabelId(label.name()), this.getId());
        }
        catch (ConstraintViolationKernelException e) {
            throw new ConstraintViolationException("Unable to add label.", e);
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLabel(Label label) {
        StatementContext ctx = this.statementCtxProvider.getCtxForWriting();
        try {
            ctx.removeLabelFromNode(ctx.getLabelId(label.name()), this.getId());
        }
        catch (LabelNotFoundKernelException labelNotFoundKernelException) {
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLabel(Label label) {
        StatementContext ctx = this.statementCtxProvider.getCtxForReading();
        try {
            boolean bl = ctx.isLabelSetOnNode(ctx.getLabelId(label.name()), this.getId());
            return bl;
        }
        catch (LabelNotFoundKernelException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            ctx.close();
        }
    }

    public ResourceIterable<Label> getLabels() {
        return new ResourceIterable<Label>(){

            @Override
            public ResourceIterator<Label> iterator() {
                final StatementContext ctx = NodeProxy.this.statementCtxProvider.getCtxForReading();
                return IteratorUtil.withResource(Iterables.map(new Function<Long, Label>(){

                    @Override
                    public Label apply(Long labelId) {
                        try {
                            return DynamicLabel.label(ctx.getLabelName(labelId));
                        }
                        catch (LabelNotFoundKernelException e) {
                            throw new ThisShouldNotHappenError("Mattias", "Listed labels for node " + NodeProxy.this.nodeId + ", but the returned label " + labelId + " doesn't exist anymore");
                        }
                    }
                }, ctx.getLabelsForNode(NodeProxy.this.getId())), ctx);
            }
        };
    }

    public static interface NodeLookup {
        public NodeImpl lookup(long var1);

        public GraphDatabaseService getGraphDatabase();

        public NodeManager getNodeManager();

        public NodeImpl lookup(long var1, LockType var3);
    }
}

