/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.Future;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;

public class OnlineIndexProxy
implements IndexProxy {
    private final IndexDescriptor descriptor;
    private final IndexAccessor accessor;

    public OnlineIndexProxy(IndexDescriptor descriptor, IndexAccessor accessor) {
        this.descriptor = descriptor;
        this.accessor = accessor;
    }

    @Override
    public void start() {
    }

    @Override
    public void update(Iterable<NodePropertyUpdate> updates) throws IOException {
        this.accessor.updateAndCommit(updates);
    }

    @Override
    public void recover(Iterable<NodePropertyUpdate> updates) throws IOException {
        this.accessor.recover(updates);
    }

    @Override
    public Future<Void> drop() throws IOException {
        this.accessor.drop();
        return FutureAdapter.VOID;
    }

    @Override
    public IndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.ONLINE;
    }

    @Override
    public void force() throws IOException {
        this.accessor.force();
    }

    @Override
    public Future<Void> close() throws IOException {
        this.accessor.close();
        return FutureAdapter.VOID;
    }

    @Override
    public IndexReader newReader() {
        return this.accessor.newReader();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[accessor:" + this.accessor + ", descriptor:" + this.descriptor + "]";
    }
}

