/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.Future;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;

public abstract class AbstractSwallowingIndexProxy
implements IndexProxy {
    private final IndexDescriptor descriptor;
    private final Throwable cause;

    public AbstractSwallowingIndexProxy(IndexDescriptor descriptor, Throwable cause) {
        this.descriptor = descriptor;
        this.cause = cause;
    }

    @Override
    public void start() {
        String message = "Unable to start index, it is in a " + this.getState().name() + " state.";
        throw new UnsupportedOperationException(message, this.cause);
    }

    @Override
    public void update(Iterable<NodePropertyUpdate> updates) {
    }

    @Override
    public void recover(Iterable<NodePropertyUpdate> updates) throws IOException {
    }

    @Override
    public void force() {
    }

    @Override
    public IndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Future<Void> close() {
        return FutureAdapter.VOID;
    }

    @Override
    public IndexReader newReader() {
        throw new UnsupportedOperationException();
    }
}

