/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.PlaceboTransaction;
import org.neo4j.kernel.TopLevelTransaction;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.TransactionContext;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;

public class TransactionLifecycleTransactionContext
implements TransactionContext {
    private final TransactionContext actual;
    private final AbstractTransactionManager transactionManager;
    private final org.neo4j.graphdb.Transaction transaction;

    public TransactionLifecycleTransactionContext(TransactionContext actual, AbstractTransactionManager transactionManager) {
        this.actual = actual;
        this.transactionManager = transactionManager;
        this.transaction = this.getOrBeginTransaction();
    }

    private org.neo4j.graphdb.Transaction getOrBeginTransaction() {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            if (tx != null) {
                return new PlaceboTransaction(this.transactionManager, null);
            }
            this.transactionManager.begin();
            return new TopLevelTransaction(this.transactionManager, null);
        }
        catch (SystemException e) {
            throw new TransactionFailureException("Couldn't get transaction", e);
        }
        catch (NotSupportedException e) {
            throw new TransactionFailureException("Couldn't begin transaction", e);
        }
    }

    @Override
    public StatementContext newStatementContext() {
        return this.actual.newStatementContext();
    }

    @Override
    public void prepare() {
    }

    @Override
    public void commit() {
        this.transaction.success();
        this.transaction.finish();
    }

    @Override
    public void rollback() {
        this.transaction.failure();
        this.transaction.finish();
    }
}

