/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.TransactionContext;
import org.neo4j.kernel.impl.api.CachingStatementContext;
import org.neo4j.kernel.impl.api.DelegatingTransactionContext;
import org.neo4j.kernel.impl.api.OldBridgingTransactionStateStatementContext;
import org.neo4j.kernel.impl.api.PersistenceCache;
import org.neo4j.kernel.impl.api.SchemaCache;
import org.neo4j.kernel.impl.api.SchemaStateOperations;
import org.neo4j.kernel.impl.api.TransactionStateStatementContext;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.core.TransactionState;

public class StateHandlingTransactionContext
extends DelegatingTransactionContext {
    private final PersistenceCache persistenceCache;
    private final TxState state;
    private final SchemaCache schemaCache;
    @Deprecated
    private final TransactionState oldTransactionState;
    private final UpdateableSchemaState schemaState;

    public StateHandlingTransactionContext(TransactionContext actual, TxState state, PersistenceCache persistenceCache, TransactionState oldTransactionState, SchemaCache schemaCache, UpdateableSchemaState schemaState) {
        super(actual);
        this.persistenceCache = persistenceCache;
        this.oldTransactionState = oldTransactionState;
        this.schemaCache = schemaCache;
        this.schemaState = schemaState;
        this.state = state;
    }

    @Override
    public StatementContext newStatementContext() {
        StatementContext result = super.newStatementContext();
        result = new CachingStatementContext(result, this.persistenceCache, this.schemaCache);
        SchemaStateOperations schemaStateFlushing = new SchemaStateOperations(result, this.schemaState);
        result = new TransactionStateStatementContext(result, schemaStateFlushing, this.state);
        result = new OldBridgingTransactionStateStatementContext(result, this.oldTransactionState);
        return result;
    }

    @Override
    public void commit() {
        super.commit();
        this.persistenceCache.apply(this.state);
        if (this.state.haveIndexesBeenDropped()) {
            this.schemaState.flush();
        }
    }
}

