/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.TransactionContext;
import org.neo4j.kernel.impl.api.DelegatingTransactionContext;
import org.neo4j.kernel.impl.api.LockHolder;
import org.neo4j.kernel.impl.api.LockingStatementContext;
import org.neo4j.kernel.impl.transaction.LockManager;

public class LockingTransactionContext
extends DelegatingTransactionContext {
    private final LockHolder lockHolder;

    public LockingTransactionContext(TransactionContext actual, LockManager lockManager, TransactionManager transactionManager) {
        super(actual);
        try {
            this.lockHolder = new LockHolder(lockManager, transactionManager.getTransaction());
        }
        catch (SystemException e) {
            throw new TransactionFailureException("Unable to get transaction", e);
        }
    }

    @Override
    public StatementContext newStatementContext() {
        StatementContext result = super.newStatementContext();
        result = new LockingStatementContext(result, this.lockHolder);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        try {
            super.commit();
        }
        finally {
            this.lockHolder.releaseLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        try {
            super.rollback();
        }
        finally {
            this.lockHolder.releaseLocks();
        }
    }
}

