/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public abstract class SchemaIndexProvider
extends LifecycleAdapter
implements Comparable<SchemaIndexProvider> {
    public static final SchemaIndexProvider NO_INDEX_PROVIDER = new SchemaIndexProvider(-1){
        private final IndexAccessor singleWriter = new IndexAccessor.Adapter();
        private final IndexPopulator singlePopulator = new IndexPopulator.Adapter();

        @Override
        public IndexAccessor getOnlineAccessor(long indexId) {
            return this.singleWriter;
        }

        @Override
        public IndexPopulator getPopulator(long indexId) {
            return this.singlePopulator;
        }

        @Override
        public InternalIndexState getInitialState(long indexId) {
            return InternalIndexState.POPULATING;
        }
    };
    public static final DependencyResolver.SelectionStrategy<SchemaIndexProvider> HIGHEST_PRIORITIZED_OR_NONE = new DependencyResolver.SelectionStrategy<SchemaIndexProvider>(){

        @Override
        public SchemaIndexProvider select(Class<SchemaIndexProvider> type, Iterable<SchemaIndexProvider> candidates) throws IllegalArgumentException {
            List all = IteratorUtil.addToCollection(candidates, new ArrayList());
            if (all.isEmpty()) {
                return NO_INDEX_PROVIDER;
            }
            Collections.sort(all);
            return (SchemaIndexProvider)all.get(all.size() - 1);
        }
    };
    private final int priority;

    protected SchemaIndexProvider(int priority) {
        this.priority = priority;
    }

    public abstract IndexPopulator getPopulator(long var1);

    public abstract IndexAccessor getOnlineAccessor(long var1);

    public abstract InternalIndexState getInitialState(long var1);

    @Override
    public int compareTo(SchemaIndexProvider o) {
        return this.priority - o.priority;
    }

    protected File getRootDirectory(Config config, String key) {
        return new File(new File(new File(config.get(GraphDatabaseSettings.store_dir), "schema"), "index"), key);
    }
}

