/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;

public class ThreadToStatementContextBridge {
    private final KernelAPI kernelAPI;
    private final AbstractTransactionManager txManager;

    public ThreadToStatementContextBridge(KernelAPI kernelAPI, AbstractTransactionManager txManager) {
        this.kernelAPI = kernelAPI;
        this.txManager = txManager;
    }

    public StatementContext getCtxForReading() {
        StatementContext ctx = this.getStatementContext();
        if (ctx != null) {
            return ctx;
        }
        return this.kernelAPI.newReadOnlyStatementContext();
    }

    public StatementContext getCtxForWriting() {
        StatementContext ctx = this.getStatementContext();
        if (ctx != null) {
            return ctx;
        }
        throw new NotInTransactionException("You have to start a transaction to perform write operations.");
    }

    private StatementContext getStatementContext() {
        return this.txManager.getStatementContext();
    }
}

